<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SettingsReplaceContainer StructType
 * @subpackage Structs
 */
class SettingsReplaceContainer extends AbstractStructBase
{
    /**
     * The accountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $accountId;
    /**
     * The SendTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SendTime;
    /**
     * The ResendTimes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResendTimes;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The ActivisionTokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivisionTokenId;
    /**
     * The OldValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OldValue;
    /**
     * The NewValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewValue;
    /**
     * Constructor method for SettingsReplaceContainer
     * @uses SettingsReplaceContainer::setAccountId()
     * @uses SettingsReplaceContainer::setSendTime()
     * @uses SettingsReplaceContainer::setResendTimes()
     * @uses SettingsReplaceContainer::setCode()
     * @uses SettingsReplaceContainer::setActivisionTokenId()
     * @uses SettingsReplaceContainer::setOldValue()
     * @uses SettingsReplaceContainer::setNewValue()
     * @param int $accountId
     * @param string $sendTime
     * @param int $resendTimes
     * @param string $code
     * @param string $activisionTokenId
     * @param string $oldValue
     * @param string $newValue
     */
    public function __construct($accountId = null, $sendTime = null, $resendTimes = null, $code = null, $activisionTokenId = null, $oldValue = null, $newValue = null)
    {
        $this
            ->setAccountId($accountId)
            ->setSendTime($sendTime)
            ->setResendTimes($resendTimes)
            ->setCode($code)
            ->setActivisionTokenId($activisionTokenId)
            ->setOldValue($oldValue)
            ->setNewValue($newValue);
    }
    /**
     * Get accountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->accountId;
    }
    /**
     * Set accountId value
     * @param int $accountId
     * @return \StructType\SettingsReplaceContainer
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->accountId = $accountId;
        return $this;
    }
    /**
     * Get SendTime value
     * @return string
     */
    public function getSendTime()
    {
        return $this->SendTime;
    }
    /**
     * Set SendTime value
     * @param string $sendTime
     * @return \StructType\SettingsReplaceContainer
     */
    public function setSendTime($sendTime = null)
    {
        // validation for constraint: string
        if (!is_null($sendTime) && !is_string($sendTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendTime, true), gettype($sendTime)), __LINE__);
        }
        $this->SendTime = $sendTime;
        return $this;
    }
    /**
     * Get ResendTimes value
     * @return int
     */
    public function getResendTimes()
    {
        return $this->ResendTimes;
    }
    /**
     * Set ResendTimes value
     * @param int $resendTimes
     * @return \StructType\SettingsReplaceContainer
     */
    public function setResendTimes($resendTimes = null)
    {
        // validation for constraint: int
        if (!is_null($resendTimes) && !(is_int($resendTimes) || ctype_digit($resendTimes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resendTimes, true), gettype($resendTimes)), __LINE__);
        }
        $this->ResendTimes = $resendTimes;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\SettingsReplaceContainer
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ActivisionTokenId value
     * @return string|null
     */
    public function getActivisionTokenId()
    {
        return $this->ActivisionTokenId;
    }
    /**
     * Set ActivisionTokenId value
     * @param string $activisionTokenId
     * @return \StructType\SettingsReplaceContainer
     */
    public function setActivisionTokenId($activisionTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($activisionTokenId) && !is_string($activisionTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activisionTokenId, true), gettype($activisionTokenId)), __LINE__);
        }
        $this->ActivisionTokenId = $activisionTokenId;
        return $this;
    }
    /**
     * Get OldValue value
     * @return string|null
     */
    public function getOldValue()
    {
        return $this->OldValue;
    }
    /**
     * Set OldValue value
     * @param string $oldValue
     * @return \StructType\SettingsReplaceContainer
     */
    public function setOldValue($oldValue = null)
    {
        // validation for constraint: string
        if (!is_null($oldValue) && !is_string($oldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldValue, true), gettype($oldValue)), __LINE__);
        }
        $this->OldValue = $oldValue;
        return $this;
    }
    /**
     * Get NewValue value
     * @return string|null
     */
    public function getNewValue()
    {
        return $this->NewValue;
    }
    /**
     * Set NewValue value
     * @param string $newValue
     * @return \StructType\SettingsReplaceContainer
     */
    public function setNewValue($newValue = null)
    {
        // validation for constraint: string
        if (!is_null($newValue) && !is_string($newValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newValue, true), gettype($newValue)), __LINE__);
        }
        $this->NewValue = $newValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SettingsReplaceContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
