<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendMoneyforSdk StructType
 * @subpackage Structs
 */
class SendMoneyforSdk extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $amount;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The appId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appId;
    /**
     * The appPackageName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appPackageName;
    /**
     * The fromWallet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fromWallet;
    /**
     * The toWallet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $toWallet;
    /**
     * The amount2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $amount2;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * Constructor method for SendMoneyforSdk
     * @uses SendMoneyforSdk::setAmount()
     * @uses SendMoneyforSdk::setTokenId()
     * @uses SendMoneyforSdk::setAppId()
     * @uses SendMoneyforSdk::setAppPackageName()
     * @uses SendMoneyforSdk::setFromWallet()
     * @uses SendMoneyforSdk::setToWallet()
     * @uses SendMoneyforSdk::setAmount2()
     * @uses SendMoneyforSdk::setDescription()
     * @uses SendMoneyforSdk::setLanguage()
     * @param int $amount
     * @param string $tokenId
     * @param string $appId
     * @param string $appPackageName
     * @param string $fromWallet
     * @param string $toWallet
     * @param string $amount2
     * @param string $description
     * @param string $language
     */
    public function __construct($amount = null, $tokenId = null, $appId = null, $appPackageName = null, $fromWallet = null, $toWallet = null, $amount2 = null, $description = null, $language = null)
    {
        $this
            ->setAmount($amount)
            ->setTokenId($tokenId)
            ->setAppId($appId)
            ->setAppPackageName($appPackageName)
            ->setFromWallet($fromWallet)
            ->setToWallet($toWallet)
            ->setAmount2($amount2)
            ->setDescription($description)
            ->setLanguage($language);
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\SendMoneyforSdk
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\SendMoneyforSdk
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get appId value
     * @return string|null
     */
    public function getAppId()
    {
        return $this->appId;
    }
    /**
     * Set appId value
     * @param string $appId
     * @return \StructType\SendMoneyforSdk
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: string
        if (!is_null($appId) && !is_string($appId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appId, true), gettype($appId)), __LINE__);
        }
        $this->appId = $appId;
        return $this;
    }
    /**
     * Get appPackageName value
     * @return string|null
     */
    public function getAppPackageName()
    {
        return $this->appPackageName;
    }
    /**
     * Set appPackageName value
     * @param string $appPackageName
     * @return \StructType\SendMoneyforSdk
     */
    public function setAppPackageName($appPackageName = null)
    {
        // validation for constraint: string
        if (!is_null($appPackageName) && !is_string($appPackageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appPackageName, true), gettype($appPackageName)), __LINE__);
        }
        $this->appPackageName = $appPackageName;
        return $this;
    }
    /**
     * Get fromWallet value
     * @return string|null
     */
    public function getFromWallet()
    {
        return $this->fromWallet;
    }
    /**
     * Set fromWallet value
     * @param string $fromWallet
     * @return \StructType\SendMoneyforSdk
     */
    public function setFromWallet($fromWallet = null)
    {
        // validation for constraint: string
        if (!is_null($fromWallet) && !is_string($fromWallet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromWallet, true), gettype($fromWallet)), __LINE__);
        }
        $this->fromWallet = $fromWallet;
        return $this;
    }
    /**
     * Get toWallet value
     * @return string|null
     */
    public function getToWallet()
    {
        return $this->toWallet;
    }
    /**
     * Set toWallet value
     * @param string $toWallet
     * @return \StructType\SendMoneyforSdk
     */
    public function setToWallet($toWallet = null)
    {
        // validation for constraint: string
        if (!is_null($toWallet) && !is_string($toWallet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toWallet, true), gettype($toWallet)), __LINE__);
        }
        $this->toWallet = $toWallet;
        return $this;
    }
    /**
     * Get amount2 value
     * @return string|null
     */
    public function getAmount2()
    {
        return $this->amount2;
    }
    /**
     * Set amount2 value
     * @param string $amount2
     * @return \StructType\SendMoneyforSdk
     */
    public function setAmount2($amount2 = null)
    {
        // validation for constraint: string
        if (!is_null($amount2) && !is_string($amount2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount2, true), gettype($amount2)), __LINE__);
        }
        $this->amount2 = $amount2;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SendMoneyforSdk
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\SendMoneyforSdk
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendMoneyforSdk
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
