<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultOfDecimal StructType
 * @subpackage Structs
 */
class ResultOfDecimal extends AbstractStructBase
{
    /**
     * The ResultObject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ResultObject;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultCode;
    /**
     * The ResultStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ResultStatus;
    /**
     * The ResultMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultMessage;
    /**
     * The ResultInnerMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultInnerMessage;
    /**
     * Constructor method for ResultOfDecimal
     * @uses ResultOfDecimal::setResultObject()
     * @uses ResultOfDecimal::setResultCode()
     * @uses ResultOfDecimal::setResultStatus()
     * @uses ResultOfDecimal::setResultMessage()
     * @uses ResultOfDecimal::setResultInnerMessage()
     * @param float $resultObject
     * @param int $resultCode
     * @param bool $resultStatus
     * @param string $resultMessage
     * @param string $resultInnerMessage
     */
    public function __construct($resultObject = null, $resultCode = null, $resultStatus = null, $resultMessage = null, $resultInnerMessage = null)
    {
        $this
            ->setResultObject($resultObject)
            ->setResultCode($resultCode)
            ->setResultStatus($resultStatus)
            ->setResultMessage($resultMessage)
            ->setResultInnerMessage($resultInnerMessage);
    }
    /**
     * Get ResultObject value
     * @return float
     */
    public function getResultObject()
    {
        return $this->ResultObject;
    }
    /**
     * Set ResultObject value
     * @param float $resultObject
     * @return \StructType\ResultOfDecimal
     */
    public function setResultObject($resultObject = null)
    {
        // validation for constraint: float
        if (!is_null($resultObject) && !(is_float($resultObject) || is_numeric($resultObject))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($resultObject, true), gettype($resultObject)), __LINE__);
        }
        $this->ResultObject = $resultObject;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return int
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param int $resultCode
     * @return \StructType\ResultOfDecimal
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !(is_int($resultCode) || ctype_digit($resultCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultStatus value
     * @return bool
     */
    public function getResultStatus()
    {
        return $this->ResultStatus;
    }
    /**
     * Set ResultStatus value
     * @param bool $resultStatus
     * @return \StructType\ResultOfDecimal
     */
    public function setResultStatus($resultStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($resultStatus) && !is_bool($resultStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resultStatus, true), gettype($resultStatus)), __LINE__);
        }
        $this->ResultStatus = $resultStatus;
        return $this;
    }
    /**
     * Get ResultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->ResultMessage;
    }
    /**
     * Set ResultMessage value
     * @param string $resultMessage
     * @return \StructType\ResultOfDecimal
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->ResultMessage = $resultMessage;
        return $this;
    }
    /**
     * Get ResultInnerMessage value
     * @return string|null
     */
    public function getResultInnerMessage()
    {
        return $this->ResultInnerMessage;
    }
    /**
     * Set ResultInnerMessage value
     * @param string $resultInnerMessage
     * @return \StructType\ResultOfDecimal
     */
    public function setResultInnerMessage($resultInnerMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultInnerMessage) && !is_string($resultInnerMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultInnerMessage, true), gettype($resultInnerMessage)), __LINE__);
        }
        $this->ResultInnerMessage = $resultInnerMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResultOfDecimal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
