<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResetAccountPassword StructType
 * @subpackage Structs
 */
class ResetAccountPassword extends AbstractStructBase
{
    /**
     * The accountTokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountTokenId;
    /**
     * The pass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pass;
    /**
     * Constructor method for ResetAccountPassword
     * @uses ResetAccountPassword::setAccountTokenId()
     * @uses ResetAccountPassword::setPass()
     * @param string $accountTokenId
     * @param string $pass
     */
    public function __construct($accountTokenId = null, $pass = null)
    {
        $this
            ->setAccountTokenId($accountTokenId)
            ->setPass($pass);
    }
    /**
     * Get accountTokenId value
     * @return string|null
     */
    public function getAccountTokenId()
    {
        return $this->accountTokenId;
    }
    /**
     * Set accountTokenId value
     * @param string $accountTokenId
     * @return \StructType\ResetAccountPassword
     */
    public function setAccountTokenId($accountTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($accountTokenId) && !is_string($accountTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountTokenId, true), gettype($accountTokenId)), __LINE__);
        }
        $this->accountTokenId = $accountTokenId;
        return $this;
    }
    /**
     * Get pass value
     * @return string|null
     */
    public function getPass()
    {
        return $this->pass;
    }
    /**
     * Set pass value
     * @param string $pass
     * @return \StructType\ResetAccountPassword
     */
    public function setPass($pass = null)
    {
        // validation for constraint: string
        if (!is_null($pass) && !is_string($pass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pass, true), gettype($pass)), __LINE__);
        }
        $this->pass = $pass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResetAccountPassword
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
