<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplacePhone StructType
 * @subpackage Structs
 */
class ReplacePhone extends AbstractStructBase
{
    /**
     * The oldPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $oldPhone;
    /**
     * The newPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $newPhone;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * Constructor method for ReplacePhone
     * @uses ReplacePhone::setOldPhone()
     * @uses ReplacePhone::setNewPhone()
     * @uses ReplacePhone::setTokenId()
     * @param int $oldPhone
     * @param int $newPhone
     * @param string $tokenId
     */
    public function __construct($oldPhone = null, $newPhone = null, $tokenId = null)
    {
        $this
            ->setOldPhone($oldPhone)
            ->setNewPhone($newPhone)
            ->setTokenId($tokenId);
    }
    /**
     * Get oldPhone value
     * @return int
     */
    public function getOldPhone()
    {
        return $this->oldPhone;
    }
    /**
     * Set oldPhone value
     * @param int $oldPhone
     * @return \StructType\ReplacePhone
     */
    public function setOldPhone($oldPhone = null)
    {
        // validation for constraint: int
        if (!is_null($oldPhone) && !(is_int($oldPhone) || ctype_digit($oldPhone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oldPhone, true), gettype($oldPhone)), __LINE__);
        }
        $this->oldPhone = $oldPhone;
        return $this;
    }
    /**
     * Get newPhone value
     * @return int
     */
    public function getNewPhone()
    {
        return $this->newPhone;
    }
    /**
     * Set newPhone value
     * @param int $newPhone
     * @return \StructType\ReplacePhone
     */
    public function setNewPhone($newPhone = null)
    {
        // validation for constraint: int
        if (!is_null($newPhone) && !(is_int($newPhone) || ctype_digit($newPhone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newPhone, true), gettype($newPhone)), __LINE__);
        }
        $this->newPhone = $newPhone;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\ReplacePhone
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReplacePhone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
