<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplaceMail StructType
 * @subpackage Structs
 */
class ReplaceMail extends AbstractStructBase
{
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The oldMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $oldMail;
    /**
     * The newMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $newMail;
    /**
     * Constructor method for ReplaceMail
     * @uses ReplaceMail::setTokenId()
     * @uses ReplaceMail::setOldMail()
     * @uses ReplaceMail::setNewMail()
     * @param string $tokenId
     * @param string $oldMail
     * @param string $newMail
     */
    public function __construct($tokenId = null, $oldMail = null, $newMail = null)
    {
        $this
            ->setTokenId($tokenId)
            ->setOldMail($oldMail)
            ->setNewMail($newMail);
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\ReplaceMail
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get oldMail value
     * @return string|null
     */
    public function getOldMail()
    {
        return $this->oldMail;
    }
    /**
     * Set oldMail value
     * @param string $oldMail
     * @return \StructType\ReplaceMail
     */
    public function setOldMail($oldMail = null)
    {
        // validation for constraint: string
        if (!is_null($oldMail) && !is_string($oldMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldMail, true), gettype($oldMail)), __LINE__);
        }
        $this->oldMail = $oldMail;
        return $this;
    }
    /**
     * Get newMail value
     * @return string|null
     */
    public function getNewMail()
    {
        return $this->newMail;
    }
    /**
     * Set newMail value
     * @param string $newMail
     * @return \StructType\ReplaceMail
     */
    public function setNewMail($newMail = null)
    {
        // validation for constraint: string
        if (!is_null($newMail) && !is_string($newMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newMail, true), gettype($newMail)), __LINE__);
        }
        $this->newMail = $newMail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReplaceMail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
