<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayPointBillInquiry StructType
 * @subpackage Structs
 */
class PayPointBillInquiry extends AbstractStructBase
{
    /**
     * The InstitutionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InstitutionId;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The SubcriberNo1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubcriberNo1;
    /**
     * The SubcriberNo2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubcriberNo2;
    /**
     * Constructor method for PayPointBillInquiry
     * @uses PayPointBillInquiry::setInstitutionId()
     * @uses PayPointBillInquiry::setTokenId()
     * @uses PayPointBillInquiry::setSubcriberNo1()
     * @uses PayPointBillInquiry::setSubcriberNo2()
     * @param int $institutionId
     * @param string $tokenId
     * @param string $subcriberNo1
     * @param string $subcriberNo2
     */
    public function __construct($institutionId = null, $tokenId = null, $subcriberNo1 = null, $subcriberNo2 = null)
    {
        $this
            ->setInstitutionId($institutionId)
            ->setTokenId($tokenId)
            ->setSubcriberNo1($subcriberNo1)
            ->setSubcriberNo2($subcriberNo2);
    }
    /**
     * Get InstitutionId value
     * @return int
     */
    public function getInstitutionId()
    {
        return $this->InstitutionId;
    }
    /**
     * Set InstitutionId value
     * @param int $institutionId
     * @return \StructType\PayPointBillInquiry
     */
    public function setInstitutionId($institutionId = null)
    {
        // validation for constraint: int
        if (!is_null($institutionId) && !(is_int($institutionId) || ctype_digit($institutionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($institutionId, true), gettype($institutionId)), __LINE__);
        }
        $this->InstitutionId = $institutionId;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\PayPointBillInquiry
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get SubcriberNo1 value
     * @return string|null
     */
    public function getSubcriberNo1()
    {
        return $this->SubcriberNo1;
    }
    /**
     * Set SubcriberNo1 value
     * @param string $subcriberNo1
     * @return \StructType\PayPointBillInquiry
     */
    public function setSubcriberNo1($subcriberNo1 = null)
    {
        // validation for constraint: string
        if (!is_null($subcriberNo1) && !is_string($subcriberNo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcriberNo1, true), gettype($subcriberNo1)), __LINE__);
        }
        $this->SubcriberNo1 = $subcriberNo1;
        return $this;
    }
    /**
     * Get SubcriberNo2 value
     * @return string|null
     */
    public function getSubcriberNo2()
    {
        return $this->SubcriberNo2;
    }
    /**
     * Set SubcriberNo2 value
     * @param string $subcriberNo2
     * @return \StructType\PayPointBillInquiry
     */
    public function setSubcriberNo2($subcriberNo2 = null)
    {
        // validation for constraint: string
        if (!is_null($subcriberNo2) && !is_string($subcriberNo2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcriberNo2, true), gettype($subcriberNo2)), __LINE__);
        }
        $this->SubcriberNo2 = $subcriberNo2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PayPointBillInquiry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
