<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoneyRequestConfirm StructType
 * @subpackage Structs
 */
class MoneyRequestConfirm extends AbstractStructBase
{
    /**
     * The transactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $transactionId;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The walletCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $walletCode;
    /**
     * Constructor method for MoneyRequestConfirm
     * @uses MoneyRequestConfirm::setTransactionId()
     * @uses MoneyRequestConfirm::setTokenId()
     * @uses MoneyRequestConfirm::setWalletCode()
     * @param int $transactionId
     * @param string $tokenId
     * @param string $walletCode
     */
    public function __construct($transactionId = null, $tokenId = null, $walletCode = null)
    {
        $this
            ->setTransactionId($transactionId)
            ->setTokenId($tokenId)
            ->setWalletCode($walletCode);
    }
    /**
     * Get transactionId value
     * @return int
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param int $transactionId
     * @return \StructType\MoneyRequestConfirm
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !(is_int($transactionId) || ctype_digit($transactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\MoneyRequestConfirm
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get walletCode value
     * @return string|null
     */
    public function getWalletCode()
    {
        return $this->walletCode;
    }
    /**
     * Set walletCode value
     * @param string $walletCode
     * @return \StructType\MoneyRequestConfirm
     */
    public function setWalletCode($walletCode = null)
    {
        // validation for constraint: string
        if (!is_null($walletCode) && !is_string($walletCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletCode, true), gettype($walletCode)), __LINE__);
        }
        $this->walletCode = $walletCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MoneyRequestConfirm
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
