<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileValidationContainer StructType
 * @subpackage Structs
 */
class MobileValidationContainer extends AbstractStructBase
{
    /**
     * The accountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $accountId;
    /**
     * The sendTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sendTime;
    /**
     * The resendTimes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $resendTimes;
    /**
     * The errorTimes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $errorTimes;
    /**
     * The TokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TokenId;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The deviceKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceKey;
    /**
     * The accountToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountToken;
    /**
     * Constructor method for MobileValidationContainer
     * @uses MobileValidationContainer::setAccountId()
     * @uses MobileValidationContainer::setSendTime()
     * @uses MobileValidationContainer::setResendTimes()
     * @uses MobileValidationContainer::setErrorTimes()
     * @uses MobileValidationContainer::setTokenId()
     * @uses MobileValidationContainer::setCode()
     * @uses MobileValidationContainer::setDeviceKey()
     * @uses MobileValidationContainer::setAccountToken()
     * @param int $accountId
     * @param string $sendTime
     * @param int $resendTimes
     * @param int $errorTimes
     * @param string $tokenId
     * @param string $code
     * @param string $deviceKey
     * @param string $accountToken
     */
    public function __construct($accountId = null, $sendTime = null, $resendTimes = null, $errorTimes = null, $tokenId = null, $code = null, $deviceKey = null, $accountToken = null)
    {
        $this
            ->setAccountId($accountId)
            ->setSendTime($sendTime)
            ->setResendTimes($resendTimes)
            ->setErrorTimes($errorTimes)
            ->setTokenId($tokenId)
            ->setCode($code)
            ->setDeviceKey($deviceKey)
            ->setAccountToken($accountToken);
    }
    /**
     * Get accountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->accountId;
    }
    /**
     * Set accountId value
     * @param int $accountId
     * @return \StructType\MobileValidationContainer
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->accountId = $accountId;
        return $this;
    }
    /**
     * Get sendTime value
     * @return string
     */
    public function getSendTime()
    {
        return $this->sendTime;
    }
    /**
     * Set sendTime value
     * @param string $sendTime
     * @return \StructType\MobileValidationContainer
     */
    public function setSendTime($sendTime = null)
    {
        // validation for constraint: string
        if (!is_null($sendTime) && !is_string($sendTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendTime, true), gettype($sendTime)), __LINE__);
        }
        $this->sendTime = $sendTime;
        return $this;
    }
    /**
     * Get resendTimes value
     * @return int
     */
    public function getResendTimes()
    {
        return $this->resendTimes;
    }
    /**
     * Set resendTimes value
     * @param int $resendTimes
     * @return \StructType\MobileValidationContainer
     */
    public function setResendTimes($resendTimes = null)
    {
        // validation for constraint: int
        if (!is_null($resendTimes) && !(is_int($resendTimes) || ctype_digit($resendTimes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resendTimes, true), gettype($resendTimes)), __LINE__);
        }
        $this->resendTimes = $resendTimes;
        return $this;
    }
    /**
     * Get errorTimes value
     * @return int
     */
    public function getErrorTimes()
    {
        return $this->errorTimes;
    }
    /**
     * Set errorTimes value
     * @param int $errorTimes
     * @return \StructType\MobileValidationContainer
     */
    public function setErrorTimes($errorTimes = null)
    {
        // validation for constraint: int
        if (!is_null($errorTimes) && !(is_int($errorTimes) || ctype_digit($errorTimes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorTimes, true), gettype($errorTimes)), __LINE__);
        }
        $this->errorTimes = $errorTimes;
        return $this;
    }
    /**
     * Get TokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->TokenId;
    }
    /**
     * Set TokenId value
     * @param string $tokenId
     * @return \StructType\MobileValidationContainer
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->TokenId = $tokenId;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\MobileValidationContainer
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get deviceKey value
     * @return string|null
     */
    public function getDeviceKey()
    {
        return $this->deviceKey;
    }
    /**
     * Set deviceKey value
     * @param string $deviceKey
     * @return \StructType\MobileValidationContainer
     */
    public function setDeviceKey($deviceKey = null)
    {
        // validation for constraint: string
        if (!is_null($deviceKey) && !is_string($deviceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceKey, true), gettype($deviceKey)), __LINE__);
        }
        $this->deviceKey = $deviceKey;
        return $this;
    }
    /**
     * Get accountToken value
     * @return string|null
     */
    public function getAccountToken()
    {
        return $this->accountToken;
    }
    /**
     * Set accountToken value
     * @param string $accountToken
     * @return \StructType\MobileValidationContainer
     */
    public function setAccountToken($accountToken = null)
    {
        // validation for constraint: string
        if (!is_null($accountToken) && !is_string($accountToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountToken, true), gettype($accountToken)), __LINE__);
        }
        $this->accountToken = $accountToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MobileValidationContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
