<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileServiceContainer StructType
 * @subpackage Structs
 */
class MobileServiceContainer extends AbstractStructBase
{
    /**
     * The accountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $accountId;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $phone;
    /**
     * The logonDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $logonDateTime;
    /**
     * The isAuthenticated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isAuthenticated;
    /**
     * The remainingTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $remainingTime;
    /**
     * The IsPinActivated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPinActivated;
    /**
     * The IsPinCreated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPinCreated;
    /**
     * The lastLogonDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastLogonDateTime;
    /**
     * The accountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountCode;
    /**
     * The mail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mail;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The accountOwnerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountOwnerName;
    /**
     * The smsTokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $smsTokenId;
    /**
     * The deviceKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceKey;
    /**
     * The phoneString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneString;
    /**
     * Constructor method for MobileServiceContainer
     * @uses MobileServiceContainer::setAccountId()
     * @uses MobileServiceContainer::setPhone()
     * @uses MobileServiceContainer::setLogonDateTime()
     * @uses MobileServiceContainer::setIsAuthenticated()
     * @uses MobileServiceContainer::setRemainingTime()
     * @uses MobileServiceContainer::setIsPinActivated()
     * @uses MobileServiceContainer::setIsPinCreated()
     * @uses MobileServiceContainer::setLastLogonDateTime()
     * @uses MobileServiceContainer::setAccountCode()
     * @uses MobileServiceContainer::setMail()
     * @uses MobileServiceContainer::setTokenId()
     * @uses MobileServiceContainer::setAccountOwnerName()
     * @uses MobileServiceContainer::setSmsTokenId()
     * @uses MobileServiceContainer::setDeviceKey()
     * @uses MobileServiceContainer::setPhoneString()
     * @param int $accountId
     * @param int $phone
     * @param string $logonDateTime
     * @param bool $isAuthenticated
     * @param int $remainingTime
     * @param bool $isPinActivated
     * @param bool $isPinCreated
     * @param string $lastLogonDateTime
     * @param string $accountCode
     * @param string $mail
     * @param string $tokenId
     * @param string $accountOwnerName
     * @param string $smsTokenId
     * @param string $deviceKey
     * @param string $phoneString
     */
    public function __construct($accountId = null, $phone = null, $logonDateTime = null, $isAuthenticated = null, $remainingTime = null, $isPinActivated = null, $isPinCreated = null, $lastLogonDateTime = null, $accountCode = null, $mail = null, $tokenId = null, $accountOwnerName = null, $smsTokenId = null, $deviceKey = null, $phoneString = null)
    {
        $this
            ->setAccountId($accountId)
            ->setPhone($phone)
            ->setLogonDateTime($logonDateTime)
            ->setIsAuthenticated($isAuthenticated)
            ->setRemainingTime($remainingTime)
            ->setIsPinActivated($isPinActivated)
            ->setIsPinCreated($isPinCreated)
            ->setLastLogonDateTime($lastLogonDateTime)
            ->setAccountCode($accountCode)
            ->setMail($mail)
            ->setTokenId($tokenId)
            ->setAccountOwnerName($accountOwnerName)
            ->setSmsTokenId($smsTokenId)
            ->setDeviceKey($deviceKey)
            ->setPhoneString($phoneString);
    }
    /**
     * Get accountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->accountId;
    }
    /**
     * Set accountId value
     * @param int $accountId
     * @return \StructType\MobileServiceContainer
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->accountId = $accountId;
        return $this;
    }
    /**
     * Get phone value
     * @return int
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param int $phone
     * @return \StructType\MobileServiceContainer
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: int
        if (!is_null($phone) && !(is_int($phone) || ctype_digit($phone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get logonDateTime value
     * @return string
     */
    public function getLogonDateTime()
    {
        return $this->logonDateTime;
    }
    /**
     * Set logonDateTime value
     * @param string $logonDateTime
     * @return \StructType\MobileServiceContainer
     */
    public function setLogonDateTime($logonDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($logonDateTime) && !is_string($logonDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logonDateTime, true), gettype($logonDateTime)), __LINE__);
        }
        $this->logonDateTime = $logonDateTime;
        return $this;
    }
    /**
     * Get isAuthenticated value
     * @return bool
     */
    public function getIsAuthenticated()
    {
        return $this->isAuthenticated;
    }
    /**
     * Set isAuthenticated value
     * @param bool $isAuthenticated
     * @return \StructType\MobileServiceContainer
     */
    public function setIsAuthenticated($isAuthenticated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAuthenticated) && !is_bool($isAuthenticated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAuthenticated, true), gettype($isAuthenticated)), __LINE__);
        }
        $this->isAuthenticated = $isAuthenticated;
        return $this;
    }
    /**
     * Get remainingTime value
     * @return int
     */
    public function getRemainingTime()
    {
        return $this->remainingTime;
    }
    /**
     * Set remainingTime value
     * @param int $remainingTime
     * @return \StructType\MobileServiceContainer
     */
    public function setRemainingTime($remainingTime = null)
    {
        // validation for constraint: int
        if (!is_null($remainingTime) && !(is_int($remainingTime) || ctype_digit($remainingTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remainingTime, true), gettype($remainingTime)), __LINE__);
        }
        $this->remainingTime = $remainingTime;
        return $this;
    }
    /**
     * Get IsPinActivated value
     * @return bool
     */
    public function getIsPinActivated()
    {
        return $this->IsPinActivated;
    }
    /**
     * Set IsPinActivated value
     * @param bool $isPinActivated
     * @return \StructType\MobileServiceContainer
     */
    public function setIsPinActivated($isPinActivated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPinActivated) && !is_bool($isPinActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPinActivated, true), gettype($isPinActivated)), __LINE__);
        }
        $this->IsPinActivated = $isPinActivated;
        return $this;
    }
    /**
     * Get IsPinCreated value
     * @return bool
     */
    public function getIsPinCreated()
    {
        return $this->IsPinCreated;
    }
    /**
     * Set IsPinCreated value
     * @param bool $isPinCreated
     * @return \StructType\MobileServiceContainer
     */
    public function setIsPinCreated($isPinCreated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPinCreated) && !is_bool($isPinCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPinCreated, true), gettype($isPinCreated)), __LINE__);
        }
        $this->IsPinCreated = $isPinCreated;
        return $this;
    }
    /**
     * Get lastLogonDateTime value
     * @return string
     */
    public function getLastLogonDateTime()
    {
        return $this->lastLogonDateTime;
    }
    /**
     * Set lastLogonDateTime value
     * @param string $lastLogonDateTime
     * @return \StructType\MobileServiceContainer
     */
    public function setLastLogonDateTime($lastLogonDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastLogonDateTime) && !is_string($lastLogonDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastLogonDateTime, true), gettype($lastLogonDateTime)), __LINE__);
        }
        $this->lastLogonDateTime = $lastLogonDateTime;
        return $this;
    }
    /**
     * Get accountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->accountCode;
    }
    /**
     * Set accountCode value
     * @param string $accountCode
     * @return \StructType\MobileServiceContainer
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        $this->accountCode = $accountCode;
        return $this;
    }
    /**
     * Get mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @param string $mail
     * @return \StructType\MobileServiceContainer
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        $this->mail = $mail;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\MobileServiceContainer
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get accountOwnerName value
     * @return string|null
     */
    public function getAccountOwnerName()
    {
        return $this->accountOwnerName;
    }
    /**
     * Set accountOwnerName value
     * @param string $accountOwnerName
     * @return \StructType\MobileServiceContainer
     */
    public function setAccountOwnerName($accountOwnerName = null)
    {
        // validation for constraint: string
        if (!is_null($accountOwnerName) && !is_string($accountOwnerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountOwnerName, true), gettype($accountOwnerName)), __LINE__);
        }
        $this->accountOwnerName = $accountOwnerName;
        return $this;
    }
    /**
     * Get smsTokenId value
     * @return string|null
     */
    public function getSmsTokenId()
    {
        return $this->smsTokenId;
    }
    /**
     * Set smsTokenId value
     * @param string $smsTokenId
     * @return \StructType\MobileServiceContainer
     */
    public function setSmsTokenId($smsTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($smsTokenId) && !is_string($smsTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smsTokenId, true), gettype($smsTokenId)), __LINE__);
        }
        $this->smsTokenId = $smsTokenId;
        return $this;
    }
    /**
     * Get deviceKey value
     * @return string|null
     */
    public function getDeviceKey()
    {
        return $this->deviceKey;
    }
    /**
     * Set deviceKey value
     * @param string $deviceKey
     * @return \StructType\MobileServiceContainer
     */
    public function setDeviceKey($deviceKey = null)
    {
        // validation for constraint: string
        if (!is_null($deviceKey) && !is_string($deviceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceKey, true), gettype($deviceKey)), __LINE__);
        }
        $this->deviceKey = $deviceKey;
        return $this;
    }
    /**
     * Get phoneString value
     * @return string|null
     */
    public function getPhoneString()
    {
        return $this->phoneString;
    }
    /**
     * Set phoneString value
     * @param string $phoneString
     * @return \StructType\MobileServiceContainer
     */
    public function setPhoneString($phoneString = null)
    {
        // validation for constraint: string
        if (!is_null($phoneString) && !is_string($phoneString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneString, true), gettype($phoneString)), __LINE__);
        }
        $this->phoneString = $phoneString;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MobileServiceContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
