<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberInfo StructType
 * @subpackage Structs
 */
class MemberInfo extends AbstractStructBase
{
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The fullName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fullName;
    /**
     * The memberEMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $memberEMail;
    /**
     * The memberId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $memberId;
    /**
     * The retVal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retVal;
    /**
     * Constructor method for MemberInfo
     * @uses MemberInfo::setExtensionData()
     * @uses MemberInfo::setFullName()
     * @uses MemberInfo::setMemberEMail()
     * @uses MemberInfo::setMemberId()
     * @uses MemberInfo::setRetVal()
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $fullName
     * @param string $memberEMail
     * @param string $memberId
     * @param string $retVal
     */
    public function __construct(\StructType\ExtensionDataObject $extensionData = null, $fullName = null, $memberEMail = null, $memberId = null, $retVal = null)
    {
        $this
            ->setExtensionData($extensionData)
            ->setFullName($fullName)
            ->setMemberEMail($memberEMail)
            ->setMemberId($memberId)
            ->setRetVal($retVal);
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\MemberInfo
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\MemberInfo
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get memberEMail value
     * @return string|null
     */
    public function getMemberEMail()
    {
        return $this->memberEMail;
    }
    /**
     * Set memberEMail value
     * @param string $memberEMail
     * @return \StructType\MemberInfo
     */
    public function setMemberEMail($memberEMail = null)
    {
        // validation for constraint: string
        if (!is_null($memberEMail) && !is_string($memberEMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberEMail, true), gettype($memberEMail)), __LINE__);
        }
        $this->memberEMail = $memberEMail;
        return $this;
    }
    /**
     * Get memberId value
     * @return string|null
     */
    public function getMemberId()
    {
        return $this->memberId;
    }
    /**
     * Set memberId value
     * @param string $memberId
     * @return \StructType\MemberInfo
     */
    public function setMemberId($memberId = null)
    {
        // validation for constraint: string
        if (!is_null($memberId) && !is_string($memberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberId, true), gettype($memberId)), __LINE__);
        }
        $this->memberId = $memberId;
        return $this;
    }
    /**
     * Get retVal value
     * @return string|null
     */
    public function getRetVal()
    {
        return $this->retVal;
    }
    /**
     * Set retVal value
     * @param string $retVal
     * @return \StructType\MemberInfo
     */
    public function setRetVal($retVal = null)
    {
        // validation for constraint: string
        if (!is_null($retVal) && !is_string($retVal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retVal, true), gettype($retVal)), __LINE__);
        }
        $this->retVal = $retVal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
