<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstitutionsListEntity StructType
 * @subpackage Structs
 */
class InstitutionsListEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CategoryId;
    /**
     * The PartialPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PartialPayment;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The institutionFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInstitutionFieldsEntity
     */
    public $institutionFields;
    /**
     * Constructor method for InstitutionsListEntity
     * @uses InstitutionsListEntity::setId()
     * @uses InstitutionsListEntity::setCategoryId()
     * @uses InstitutionsListEntity::setPartialPayment()
     * @uses InstitutionsListEntity::setName()
     * @uses InstitutionsListEntity::setInstitutionFields()
     * @param int $id
     * @param int $categoryId
     * @param bool $partialPayment
     * @param string $name
     * @param \ArrayType\ArrayOfInstitutionFieldsEntity $institutionFields
     */
    public function __construct($id = null, $categoryId = null, $partialPayment = null, $name = null, \ArrayType\ArrayOfInstitutionFieldsEntity $institutionFields = null)
    {
        $this
            ->setId($id)
            ->setCategoryId($categoryId)
            ->setPartialPayment($partialPayment)
            ->setName($name)
            ->setInstitutionFields($institutionFields);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\InstitutionsListEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get CategoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param int $categoryId
     * @return \StructType\InstitutionsListEntity
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get PartialPayment value
     * @return bool
     */
    public function getPartialPayment()
    {
        return $this->PartialPayment;
    }
    /**
     * Set PartialPayment value
     * @param bool $partialPayment
     * @return \StructType\InstitutionsListEntity
     */
    public function setPartialPayment($partialPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($partialPayment) && !is_bool($partialPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($partialPayment, true), gettype($partialPayment)), __LINE__);
        }
        $this->PartialPayment = $partialPayment;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\InstitutionsListEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get institutionFields value
     * @return \ArrayType\ArrayOfInstitutionFieldsEntity|null
     */
    public function getInstitutionFields()
    {
        return $this->institutionFields;
    }
    /**
     * Set institutionFields value
     * @param \ArrayType\ArrayOfInstitutionFieldsEntity $institutionFields
     * @return \StructType\InstitutionsListEntity
     */
    public function setInstitutionFields(\ArrayType\ArrayOfInstitutionFieldsEntity $institutionFields = null)
    {
        $this->institutionFields = $institutionFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InstitutionsListEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
