<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetWalletLastTransactionList StructType
 * @subpackage Structs
 */
class GetWalletLastTransactionList extends AbstractStructBase
{
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The walletcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $walletcode;
    /**
     * Constructor method for GetWalletLastTransactionList
     * @uses GetWalletLastTransactionList::setTokenId()
     * @uses GetWalletLastTransactionList::setWalletcode()
     * @param string $tokenId
     * @param string $walletcode
     */
    public function __construct($tokenId = null, $walletcode = null)
    {
        $this
            ->setTokenId($tokenId)
            ->setWalletcode($walletcode);
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\GetWalletLastTransactionList
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get walletcode value
     * @return string|null
     */
    public function getWalletcode()
    {
        return $this->walletcode;
    }
    /**
     * Set walletcode value
     * @param string $walletcode
     * @return \StructType\GetWalletLastTransactionList
     */
    public function setWalletcode($walletcode = null)
    {
        // validation for constraint: string
        if (!is_null($walletcode) && !is_string($walletcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletcode, true), gettype($walletcode)), __LINE__);
        }
        $this->walletcode = $walletcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetWalletLastTransactionList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
