<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSubBranchList StructType
 * @subpackage Structs
 */
class GetSubBranchList extends AbstractStructBase
{
    /**
     * The countryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countryId;
    /**
     * The cityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $cityId;
    /**
     * The countyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countyId;
    /**
     * The isLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isLocation;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The isLoadMoney
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isLoadMoney;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * Constructor method for GetSubBranchList
     * @uses GetSubBranchList::setCountryId()
     * @uses GetSubBranchList::setCityId()
     * @uses GetSubBranchList::setCountyId()
     * @uses GetSubBranchList::setIsLocation()
     * @uses GetSubBranchList::setLatitude()
     * @uses GetSubBranchList::setLongitude()
     * @uses GetSubBranchList::setIsLoadMoney()
     * @uses GetSubBranchList::setTokenId()
     * @param int $countryId
     * @param int $cityId
     * @param int $countyId
     * @param bool $isLocation
     * @param float $latitude
     * @param float $longitude
     * @param bool $isLoadMoney
     * @param string $tokenId
     */
    public function __construct($countryId = null, $cityId = null, $countyId = null, $isLocation = null, $latitude = null, $longitude = null, $isLoadMoney = null, $tokenId = null)
    {
        $this
            ->setCountryId($countryId)
            ->setCityId($cityId)
            ->setCountyId($countyId)
            ->setIsLocation($isLocation)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setIsLoadMoney($isLoadMoney)
            ->setTokenId($tokenId);
    }
    /**
     * Get countryId value
     * @return int
     */
    public function getCountryId()
    {
        return $this->countryId;
    }
    /**
     * Set countryId value
     * @param int $countryId
     * @return \StructType\GetSubBranchList
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: int
        if (!is_null($countryId) && !(is_int($countryId) || ctype_digit($countryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->countryId = $countryId;
        return $this;
    }
    /**
     * Get cityId value
     * @return int
     */
    public function getCityId()
    {
        return $this->cityId;
    }
    /**
     * Set cityId value
     * @param int $cityId
     * @return \StructType\GetSubBranchList
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: int
        if (!is_null($cityId) && !(is_int($cityId) || ctype_digit($cityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityId, true), gettype($cityId)), __LINE__);
        }
        $this->cityId = $cityId;
        return $this;
    }
    /**
     * Get countyId value
     * @return int
     */
    public function getCountyId()
    {
        return $this->countyId;
    }
    /**
     * Set countyId value
     * @param int $countyId
     * @return \StructType\GetSubBranchList
     */
    public function setCountyId($countyId = null)
    {
        // validation for constraint: int
        if (!is_null($countyId) && !(is_int($countyId) || ctype_digit($countyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countyId, true), gettype($countyId)), __LINE__);
        }
        $this->countyId = $countyId;
        return $this;
    }
    /**
     * Get isLocation value
     * @return bool
     */
    public function getIsLocation()
    {
        return $this->isLocation;
    }
    /**
     * Set isLocation value
     * @param bool $isLocation
     * @return \StructType\GetSubBranchList
     */
    public function setIsLocation($isLocation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLocation) && !is_bool($isLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLocation, true), gettype($isLocation)), __LINE__);
        }
        $this->isLocation = $isLocation;
        return $this;
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\GetSubBranchList
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\GetSubBranchList
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get isLoadMoney value
     * @return bool
     */
    public function getIsLoadMoney()
    {
        return $this->isLoadMoney;
    }
    /**
     * Set isLoadMoney value
     * @param bool $isLoadMoney
     * @return \StructType\GetSubBranchList
     */
    public function setIsLoadMoney($isLoadMoney = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLoadMoney) && !is_bool($isLoadMoney)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLoadMoney, true), gettype($isLoadMoney)), __LINE__);
        }
        $this->isLoadMoney = $isLoadMoney;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\GetSubBranchList
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSubBranchList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
