<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMessageDetailList StructType
 * @subpackage Structs
 */
class GetMessageDetailList extends AbstractStructBase
{
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The messageCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messageCode;
    /**
     * Constructor method for GetMessageDetailList
     * @uses GetMessageDetailList::setTokenId()
     * @uses GetMessageDetailList::setMessageCode()
     * @param string $tokenId
     * @param string $messageCode
     */
    public function __construct($tokenId = null, $messageCode = null)
    {
        $this
            ->setTokenId($tokenId)
            ->setMessageCode($messageCode);
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\GetMessageDetailList
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get messageCode value
     * @return string|null
     */
    public function getMessageCode()
    {
        return $this->messageCode;
    }
    /**
     * Set messageCode value
     * @param string $messageCode
     * @return \StructType\GetMessageDetailList
     */
    public function setMessageCode($messageCode = null)
    {
        // validation for constraint: string
        if (!is_null($messageCode) && !is_string($messageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageCode, true), gettype($messageCode)), __LINE__);
        }
        $this->messageCode = $messageCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMessageDetailList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
