<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForgetPassWithdMailandMobile StructType
 * @subpackage Structs
 */
class ForgetPassWithdMailandMobile extends AbstractStructBase
{
    /**
     * The mail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mail;
    /**
     * The deviceKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceKey;
    /**
     * Constructor method for ForgetPassWithdMailandMobile
     * @uses ForgetPassWithdMailandMobile::setMail()
     * @uses ForgetPassWithdMailandMobile::setDeviceKey()
     * @param string $mail
     * @param string $deviceKey
     */
    public function __construct($mail = null, $deviceKey = null)
    {
        $this
            ->setMail($mail)
            ->setDeviceKey($deviceKey);
    }
    /**
     * Get mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @param string $mail
     * @return \StructType\ForgetPassWithdMailandMobile
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        $this->mail = $mail;
        return $this;
    }
    /**
     * Get deviceKey value
     * @return string|null
     */
    public function getDeviceKey()
    {
        return $this->deviceKey;
    }
    /**
     * Set deviceKey value
     * @param string $deviceKey
     * @return \StructType\ForgetPassWithdMailandMobile
     */
    public function setDeviceKey($deviceKey = null)
    {
        // validation for constraint: string
        if (!is_null($deviceKey) && !is_string($deviceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceKey, true), gettype($deviceKey)), __LINE__);
        }
        $this->deviceKey = $deviceKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ForgetPassWithdMailandMobile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
