<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteAccountCreditCart StructType
 * @subpackage Structs
 */
class DeleteAccountCreditCart extends AbstractStructBase
{
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The cardToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardToken;
    /**
     * Constructor method for DeleteAccountCreditCart
     * @uses DeleteAccountCreditCart::setTokenId()
     * @uses DeleteAccountCreditCart::setCardToken()
     * @param string $tokenId
     * @param string $cardToken
     */
    public function __construct($tokenId = null, $cardToken = null)
    {
        $this
            ->setTokenId($tokenId)
            ->setCardToken($cardToken);
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\DeleteAccountCreditCart
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get cardToken value
     * @return string|null
     */
    public function getCardToken()
    {
        return $this->cardToken;
    }
    /**
     * Set cardToken value
     * @param string $cardToken
     * @return \StructType\DeleteAccountCreditCart
     */
    public function setCardToken($cardToken = null)
    {
        // validation for constraint: string
        if (!is_null($cardToken) && !is_string($cardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardToken, true), gettype($cardToken)), __LINE__);
        }
        $this->cardToken = $cardToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteAccountCreditCart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
