<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DashBoardEntity StructType
 * @subpackage Structs
 */
class DashBoardEntity extends AbstractStructBase
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountsEntity
     */
    public $Account;
    /**
     * The Wallet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfWalletsEntity
     */
    public $Wallet;
    /**
     * The Transaction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTransactionsEntity
     */
    public $Transaction;
    /**
     * Constructor method for DashBoardEntity
     * @uses DashBoardEntity::setAccount()
     * @uses DashBoardEntity::setWallet()
     * @uses DashBoardEntity::setTransaction()
     * @param \StructType\AccountsEntity $account
     * @param \ArrayType\ArrayOfWalletsEntity $wallet
     * @param \ArrayType\ArrayOfTransactionsEntity $transaction
     */
    public function __construct(\StructType\AccountsEntity $account = null, \ArrayType\ArrayOfWalletsEntity $wallet = null, \ArrayType\ArrayOfTransactionsEntity $transaction = null)
    {
        $this
            ->setAccount($account)
            ->setWallet($wallet)
            ->setTransaction($transaction);
    }
    /**
     * Get Account value
     * @return \StructType\AccountsEntity|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\AccountsEntity $account
     * @return \StructType\DashBoardEntity
     */
    public function setAccount(\StructType\AccountsEntity $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Wallet value
     * @return \ArrayType\ArrayOfWalletsEntity|null
     */
    public function getWallet()
    {
        return $this->Wallet;
    }
    /**
     * Set Wallet value
     * @param \ArrayType\ArrayOfWalletsEntity $wallet
     * @return \StructType\DashBoardEntity
     */
    public function setWallet(\ArrayType\ArrayOfWalletsEntity $wallet = null)
    {
        $this->Wallet = $wallet;
        return $this;
    }
    /**
     * Get Transaction value
     * @return \ArrayType\ArrayOfTransactionsEntity|null
     */
    public function getTransaction()
    {
        return $this->Transaction;
    }
    /**
     * Set Transaction value
     * @param \ArrayType\ArrayOfTransactionsEntity $transaction
     * @return \StructType\DashBoardEntity
     */
    public function setTransaction(\ArrayType\ArrayOfTransactionsEntity $transaction = null)
    {
        $this->Transaction = $transaction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DashBoardEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
