<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateWallet StructType
 * @subpackage Structs
 */
class CreateWallet extends AbstractStructBase
{
    /**
     * The walletType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $walletType;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for CreateWallet
     * @uses CreateWallet::setWalletType()
     * @uses CreateWallet::setTokenId()
     * @uses CreateWallet::setDescription()
     * @param int $walletType
     * @param string $tokenId
     * @param string $description
     */
    public function __construct($walletType = null, $tokenId = null, $description = null)
    {
        $this
            ->setWalletType($walletType)
            ->setTokenId($tokenId)
            ->setDescription($description);
    }
    /**
     * Get walletType value
     * @return int
     */
    public function getWalletType()
    {
        return $this->walletType;
    }
    /**
     * Set walletType value
     * @param int $walletType
     * @return \StructType\CreateWallet
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: int
        if (!is_null($walletType) && !(is_int($walletType) || ctype_digit($walletType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletType, true), gettype($walletType)), __LINE__);
        }
        $this->walletType = $walletType;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\CreateWallet
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CreateWallet
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateWallet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
