<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateNewBankAccount StructType
 * @subpackage Structs
 */
class CreateNewBankAccount extends AbstractStructBase
{
    /**
     * The bankId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $bankId;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The iban
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $iban;
    /**
     * Constructor method for CreateNewBankAccount
     * @uses CreateNewBankAccount::setBankId()
     * @uses CreateNewBankAccount::setTokenId()
     * @uses CreateNewBankAccount::setIban()
     * @param int $bankId
     * @param string $tokenId
     * @param string $iban
     */
    public function __construct($bankId = null, $tokenId = null, $iban = null)
    {
        $this
            ->setBankId($bankId)
            ->setTokenId($tokenId)
            ->setIban($iban);
    }
    /**
     * Get bankId value
     * @return int
     */
    public function getBankId()
    {
        return $this->bankId;
    }
    /**
     * Set bankId value
     * @param int $bankId
     * @return \StructType\CreateNewBankAccount
     */
    public function setBankId($bankId = null)
    {
        // validation for constraint: int
        if (!is_null($bankId) && !(is_int($bankId) || ctype_digit($bankId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankId, true), gettype($bankId)), __LINE__);
        }
        $this->bankId = $bankId;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\CreateNewBankAccount
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \StructType\CreateNewBankAccount
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateNewBankAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
