<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateAccount StructType
 * @subpackage Structs
 */
class CreateAccount extends AbstractStructBase
{
    /**
     * The walletType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $walletType;
    /**
     * The isContractCheck
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isContractCheck;
    /**
     * The accountTokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountTokenId;
    /**
     * The walletDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $walletDescription;
    /**
     * Constructor method for CreateAccount
     * @uses CreateAccount::setWalletType()
     * @uses CreateAccount::setIsContractCheck()
     * @uses CreateAccount::setAccountTokenId()
     * @uses CreateAccount::setWalletDescription()
     * @param int $walletType
     * @param bool $isContractCheck
     * @param string $accountTokenId
     * @param string $walletDescription
     */
    public function __construct($walletType = null, $isContractCheck = null, $accountTokenId = null, $walletDescription = null)
    {
        $this
            ->setWalletType($walletType)
            ->setIsContractCheck($isContractCheck)
            ->setAccountTokenId($accountTokenId)
            ->setWalletDescription($walletDescription);
    }
    /**
     * Get walletType value
     * @return int
     */
    public function getWalletType()
    {
        return $this->walletType;
    }
    /**
     * Set walletType value
     * @param int $walletType
     * @return \StructType\CreateAccount
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: int
        if (!is_null($walletType) && !(is_int($walletType) || ctype_digit($walletType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletType, true), gettype($walletType)), __LINE__);
        }
        $this->walletType = $walletType;
        return $this;
    }
    /**
     * Get isContractCheck value
     * @return bool
     */
    public function getIsContractCheck()
    {
        return $this->isContractCheck;
    }
    /**
     * Set isContractCheck value
     * @param bool $isContractCheck
     * @return \StructType\CreateAccount
     */
    public function setIsContractCheck($isContractCheck = null)
    {
        // validation for constraint: boolean
        if (!is_null($isContractCheck) && !is_bool($isContractCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isContractCheck, true), gettype($isContractCheck)), __LINE__);
        }
        $this->isContractCheck = $isContractCheck;
        return $this;
    }
    /**
     * Get accountTokenId value
     * @return string|null
     */
    public function getAccountTokenId()
    {
        return $this->accountTokenId;
    }
    /**
     * Set accountTokenId value
     * @param string $accountTokenId
     * @return \StructType\CreateAccount
     */
    public function setAccountTokenId($accountTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($accountTokenId) && !is_string($accountTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountTokenId, true), gettype($accountTokenId)), __LINE__);
        }
        $this->accountTokenId = $accountTokenId;
        return $this;
    }
    /**
     * Get walletDescription value
     * @return string|null
     */
    public function getWalletDescription()
    {
        return $this->walletDescription;
    }
    /**
     * Set walletDescription value
     * @param string $walletDescription
     * @return \StructType\CreateAccount
     */
    public function setWalletDescription($walletDescription = null)
    {
        // validation for constraint: string
        if (!is_null($walletDescription) && !is_string($walletDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletDescription, true), gettype($walletDescription)), __LINE__);
        }
        $this->walletDescription = $walletDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
