<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountriesEntity StructType
 * @subpackage Structs
 */
class CountriesEntity extends AbstractStructBase
{
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CountryId;
    /**
     * The IsNegotiated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNegotiated;
    /**
     * The BinaryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BinaryCode;
    /**
     * The TripleCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripleCode;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The CountryNameEng
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryNameEng;
    /**
     * The PhoneCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneCode;
    /**
     * Constructor method for CountriesEntity
     * @uses CountriesEntity::setCountryId()
     * @uses CountriesEntity::setIsNegotiated()
     * @uses CountriesEntity::setBinaryCode()
     * @uses CountriesEntity::setTripleCode()
     * @uses CountriesEntity::setCountryName()
     * @uses CountriesEntity::setCountryNameEng()
     * @uses CountriesEntity::setPhoneCode()
     * @param int $countryId
     * @param bool $isNegotiated
     * @param string $binaryCode
     * @param string $tripleCode
     * @param string $countryName
     * @param string $countryNameEng
     * @param string $phoneCode
     */
    public function __construct($countryId = null, $isNegotiated = null, $binaryCode = null, $tripleCode = null, $countryName = null, $countryNameEng = null, $phoneCode = null)
    {
        $this
            ->setCountryId($countryId)
            ->setIsNegotiated($isNegotiated)
            ->setBinaryCode($binaryCode)
            ->setTripleCode($tripleCode)
            ->setCountryName($countryName)
            ->setCountryNameEng($countryNameEng)
            ->setPhoneCode($phoneCode);
    }
    /**
     * Get CountryId value
     * @return int
     */
    public function getCountryId()
    {
        return $this->CountryId;
    }
    /**
     * Set CountryId value
     * @param int $countryId
     * @return \StructType\CountriesEntity
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: int
        if (!is_null($countryId) && !(is_int($countryId) || ctype_digit($countryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->CountryId = $countryId;
        return $this;
    }
    /**
     * Get IsNegotiated value
     * @return bool
     */
    public function getIsNegotiated()
    {
        return $this->IsNegotiated;
    }
    /**
     * Set IsNegotiated value
     * @param bool $isNegotiated
     * @return \StructType\CountriesEntity
     */
    public function setIsNegotiated($isNegotiated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNegotiated) && !is_bool($isNegotiated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNegotiated, true), gettype($isNegotiated)), __LINE__);
        }
        $this->IsNegotiated = $isNegotiated;
        return $this;
    }
    /**
     * Get BinaryCode value
     * @return string|null
     */
    public function getBinaryCode()
    {
        return $this->BinaryCode;
    }
    /**
     * Set BinaryCode value
     * @param string $binaryCode
     * @return \StructType\CountriesEntity
     */
    public function setBinaryCode($binaryCode = null)
    {
        // validation for constraint: string
        if (!is_null($binaryCode) && !is_string($binaryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binaryCode, true), gettype($binaryCode)), __LINE__);
        }
        $this->BinaryCode = $binaryCode;
        return $this;
    }
    /**
     * Get TripleCode value
     * @return string|null
     */
    public function getTripleCode()
    {
        return $this->TripleCode;
    }
    /**
     * Set TripleCode value
     * @param string $tripleCode
     * @return \StructType\CountriesEntity
     */
    public function setTripleCode($tripleCode = null)
    {
        // validation for constraint: string
        if (!is_null($tripleCode) && !is_string($tripleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripleCode, true), gettype($tripleCode)), __LINE__);
        }
        $this->TripleCode = $tripleCode;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \StructType\CountriesEntity
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryName, true), gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get CountryNameEng value
     * @return string|null
     */
    public function getCountryNameEng()
    {
        return $this->CountryNameEng;
    }
    /**
     * Set CountryNameEng value
     * @param string $countryNameEng
     * @return \StructType\CountriesEntity
     */
    public function setCountryNameEng($countryNameEng = null)
    {
        // validation for constraint: string
        if (!is_null($countryNameEng) && !is_string($countryNameEng)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryNameEng, true), gettype($countryNameEng)), __LINE__);
        }
        $this->CountryNameEng = $countryNameEng;
        return $this;
    }
    /**
     * Get PhoneCode value
     * @return string|null
     */
    public function getPhoneCode()
    {
        return $this->PhoneCode;
    }
    /**
     * Set PhoneCode value
     * @param string $phoneCode
     * @return \StructType\CountriesEntity
     */
    public function setPhoneCode($phoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($phoneCode) && !is_string($phoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneCode, true), gettype($phoneCode)), __LINE__);
        }
        $this->PhoneCode = $phoneCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CountriesEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
