<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CitiesEntity StructType
 * @subpackage Structs
 */
class CitiesEntity extends AbstractStructBase
{
    /**
     * The CityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CityId;
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CountryId;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderId;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The LicensePlateNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlateNo;
    /**
     * The PhoneCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneCode;
    /**
     * Constructor method for CitiesEntity
     * @uses CitiesEntity::setCityId()
     * @uses CitiesEntity::setCountryId()
     * @uses CitiesEntity::setOrderId()
     * @uses CitiesEntity::setCityName()
     * @uses CitiesEntity::setLicensePlateNo()
     * @uses CitiesEntity::setPhoneCode()
     * @param int $cityId
     * @param int $countryId
     * @param int $orderId
     * @param string $cityName
     * @param string $licensePlateNo
     * @param string $phoneCode
     */
    public function __construct($cityId = null, $countryId = null, $orderId = null, $cityName = null, $licensePlateNo = null, $phoneCode = null)
    {
        $this
            ->setCityId($cityId)
            ->setCountryId($countryId)
            ->setOrderId($orderId)
            ->setCityName($cityName)
            ->setLicensePlateNo($licensePlateNo)
            ->setPhoneCode($phoneCode);
    }
    /**
     * Get CityId value
     * @return int
     */
    public function getCityId()
    {
        return $this->CityId;
    }
    /**
     * Set CityId value
     * @param int $cityId
     * @return \StructType\CitiesEntity
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: int
        if (!is_null($cityId) && !(is_int($cityId) || ctype_digit($cityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityId, true), gettype($cityId)), __LINE__);
        }
        $this->CityId = $cityId;
        return $this;
    }
    /**
     * Get CountryId value
     * @return int
     */
    public function getCountryId()
    {
        return $this->CountryId;
    }
    /**
     * Set CountryId value
     * @param int $countryId
     * @return \StructType\CitiesEntity
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: int
        if (!is_null($countryId) && !(is_int($countryId) || ctype_digit($countryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->CountryId = $countryId;
        return $this;
    }
    /**
     * Get OrderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param int $orderId
     * @return \StructType\CitiesEntity
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\CitiesEntity
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get LicensePlateNo value
     * @return string|null
     */
    public function getLicensePlateNo()
    {
        return $this->LicensePlateNo;
    }
    /**
     * Set LicensePlateNo value
     * @param string $licensePlateNo
     * @return \StructType\CitiesEntity
     */
    public function setLicensePlateNo($licensePlateNo = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlateNo) && !is_string($licensePlateNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlateNo, true), gettype($licensePlateNo)), __LINE__);
        }
        $this->LicensePlateNo = $licensePlateNo;
        return $this;
    }
    /**
     * Get PhoneCode value
     * @return string|null
     */
    public function getPhoneCode()
    {
        return $this->PhoneCode;
    }
    /**
     * Set PhoneCode value
     * @param string $phoneCode
     * @return \StructType\CitiesEntity
     */
    public function setPhoneCode($phoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($phoneCode) && !is_string($phoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneCode, true), gettype($phoneCode)), __LINE__);
        }
        $this->PhoneCode = $phoneCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CitiesEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
