<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoostLimit StructType
 * @subpackage Structs
 */
class BoostLimit extends AbstractStructBase
{
    /**
     * The TcNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TcNo;
    /**
     * The countryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countryId;
    /**
     * The cityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $cityId;
    /**
     * The countyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countyId;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The TcSerialNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TcSerialNo;
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * The adress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adress;
    /**
     * Constructor method for BoostLimit
     * @uses BoostLimit::setTcNo()
     * @uses BoostLimit::setCountryId()
     * @uses BoostLimit::setCityId()
     * @uses BoostLimit::setCountyId()
     * @uses BoostLimit::setTokenId()
     * @uses BoostLimit::setTcSerialNo()
     * @uses BoostLimit::setBirthDate()
     * @uses BoostLimit::setAdress()
     * @param int $tcNo
     * @param int $countryId
     * @param int $cityId
     * @param int $countyId
     * @param string $tokenId
     * @param string $tcSerialNo
     * @param string $birthDate
     * @param string $adress
     */
    public function __construct($tcNo = null, $countryId = null, $cityId = null, $countyId = null, $tokenId = null, $tcSerialNo = null, $birthDate = null, $adress = null)
    {
        $this
            ->setTcNo($tcNo)
            ->setCountryId($countryId)
            ->setCityId($cityId)
            ->setCountyId($countyId)
            ->setTokenId($tokenId)
            ->setTcSerialNo($tcSerialNo)
            ->setBirthDate($birthDate)
            ->setAdress($adress);
    }
    /**
     * Get TcNo value
     * @return int
     */
    public function getTcNo()
    {
        return $this->TcNo;
    }
    /**
     * Set TcNo value
     * @param int $tcNo
     * @return \StructType\BoostLimit
     */
    public function setTcNo($tcNo = null)
    {
        // validation for constraint: int
        if (!is_null($tcNo) && !(is_int($tcNo) || ctype_digit($tcNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tcNo, true), gettype($tcNo)), __LINE__);
        }
        $this->TcNo = $tcNo;
        return $this;
    }
    /**
     * Get countryId value
     * @return int
     */
    public function getCountryId()
    {
        return $this->countryId;
    }
    /**
     * Set countryId value
     * @param int $countryId
     * @return \StructType\BoostLimit
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: int
        if (!is_null($countryId) && !(is_int($countryId) || ctype_digit($countryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->countryId = $countryId;
        return $this;
    }
    /**
     * Get cityId value
     * @return int
     */
    public function getCityId()
    {
        return $this->cityId;
    }
    /**
     * Set cityId value
     * @param int $cityId
     * @return \StructType\BoostLimit
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: int
        if (!is_null($cityId) && !(is_int($cityId) || ctype_digit($cityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityId, true), gettype($cityId)), __LINE__);
        }
        $this->cityId = $cityId;
        return $this;
    }
    /**
     * Get countyId value
     * @return int
     */
    public function getCountyId()
    {
        return $this->countyId;
    }
    /**
     * Set countyId value
     * @param int $countyId
     * @return \StructType\BoostLimit
     */
    public function setCountyId($countyId = null)
    {
        // validation for constraint: int
        if (!is_null($countyId) && !(is_int($countyId) || ctype_digit($countyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countyId, true), gettype($countyId)), __LINE__);
        }
        $this->countyId = $countyId;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\BoostLimit
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get TcSerialNo value
     * @return string|null
     */
    public function getTcSerialNo()
    {
        return $this->TcSerialNo;
    }
    /**
     * Set TcSerialNo value
     * @param string $tcSerialNo
     * @return \StructType\BoostLimit
     */
    public function setTcSerialNo($tcSerialNo = null)
    {
        // validation for constraint: string
        if (!is_null($tcSerialNo) && !is_string($tcSerialNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tcSerialNo, true), gettype($tcSerialNo)), __LINE__);
        }
        $this->TcSerialNo = $tcSerialNo;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\BoostLimit
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get adress value
     * @return string|null
     */
    public function getAdress()
    {
        return $this->adress;
    }
    /**
     * Set adress value
     * @param string $adress
     * @return \StructType\BoostLimit
     */
    public function setAdress($adress = null)
    {
        // validation for constraint: string
        if (!is_null($adress) && !is_string($adress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adress, true), gettype($adress)), __LINE__);
        }
        $this->adress = $adress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BoostLimit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
