<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillPayment StructType
 * @subpackage Structs
 */
class BillPayment extends AbstractStructBase
{
    /**
     * The InquiryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InquiryId;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * Constructor method for BillPayment
     * @uses BillPayment::setInquiryId()
     * @uses BillPayment::setTokenId()
     * @param int $inquiryId
     * @param string $tokenId
     */
    public function __construct($inquiryId = null, $tokenId = null)
    {
        $this
            ->setInquiryId($inquiryId)
            ->setTokenId($tokenId);
    }
    /**
     * Get InquiryId value
     * @return int
     */
    public function getInquiryId()
    {
        return $this->InquiryId;
    }
    /**
     * Set InquiryId value
     * @param int $inquiryId
     * @return \StructType\BillPayment
     */
    public function setInquiryId($inquiryId = null)
    {
        // validation for constraint: int
        if (!is_null($inquiryId) && !(is_int($inquiryId) || ctype_digit($inquiryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inquiryId, true), gettype($inquiryId)), __LINE__);
        }
        $this->InquiryId = $inquiryId;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\BillPayment
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
