<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BanksEntity StructType
 * @subpackage Structs
 */
class BanksEntity extends AbstractStructBase
{
    /**
     * The BankId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BankId;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BankCode;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountId;
    /**
     * The IsOurBank
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOurBank;
    /**
     * The PayerStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PayerStatus;
    /**
     * The IsInternetBanking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInternetBanking;
    /**
     * The TransferCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TransferCommission;
    /**
     * The OvertimeTransferCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OvertimeTransferCommission;
    /**
     * The EFTCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EFTCommission;
    /**
     * The OvertimeEFTCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OvertimeEFTCommission;
    /**
     * The CardCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CardCommission;
    /**
     * The ATMCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ATMCommission;
    /**
     * The IsCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCommission;
    /**
     * The IsActived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActived;
    /**
     * The IsDelete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDelete;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The Iban
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Iban;
    /**
     * The AccountingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountingCode;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The ShortName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortName;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageUrl;
    /**
     * The CardImageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardImageUrl;
    /**
     * The OtherCompanyBankId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherCompanyBankId;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurrencyTypesEntity
     */
    public $Currency;
    /**
     * Constructor method for BanksEntity
     * @uses BanksEntity::setBankId()
     * @uses BanksEntity::setBankCode()
     * @uses BanksEntity::setAccountId()
     * @uses BanksEntity::setIsOurBank()
     * @uses BanksEntity::setPayerStatus()
     * @uses BanksEntity::setIsInternetBanking()
     * @uses BanksEntity::setTransferCommission()
     * @uses BanksEntity::setOvertimeTransferCommission()
     * @uses BanksEntity::setEFTCommission()
     * @uses BanksEntity::setOvertimeEFTCommission()
     * @uses BanksEntity::setCardCommission()
     * @uses BanksEntity::setATMCommission()
     * @uses BanksEntity::setIsCommission()
     * @uses BanksEntity::setIsActived()
     * @uses BanksEntity::setIsDelete()
     * @uses BanksEntity::setBankName()
     * @uses BanksEntity::setIban()
     * @uses BanksEntity::setAccountingCode()
     * @uses BanksEntity::setUrl()
     * @uses BanksEntity::setShortName()
     * @uses BanksEntity::setImageUrl()
     * @uses BanksEntity::setCardImageUrl()
     * @uses BanksEntity::setOtherCompanyBankId()
     * @uses BanksEntity::setCurrency()
     * @param int $bankId
     * @param int $bankCode
     * @param int $accountId
     * @param bool $isOurBank
     * @param bool $payerStatus
     * @param bool $isInternetBanking
     * @param float $transferCommission
     * @param float $overtimeTransferCommission
     * @param float $eFTCommission
     * @param float $overtimeEFTCommission
     * @param float $cardCommission
     * @param float $aTMCommission
     * @param bool $isCommission
     * @param bool $isActived
     * @param bool $isDelete
     * @param string $bankName
     * @param string $iban
     * @param string $accountingCode
     * @param string $url
     * @param string $shortName
     * @param string $imageUrl
     * @param string $cardImageUrl
     * @param string $otherCompanyBankId
     * @param \StructType\CurrencyTypesEntity $currency
     */
    public function __construct($bankId = null, $bankCode = null, $accountId = null, $isOurBank = null, $payerStatus = null, $isInternetBanking = null, $transferCommission = null, $overtimeTransferCommission = null, $eFTCommission = null, $overtimeEFTCommission = null, $cardCommission = null, $aTMCommission = null, $isCommission = null, $isActived = null, $isDelete = null, $bankName = null, $iban = null, $accountingCode = null, $url = null, $shortName = null, $imageUrl = null, $cardImageUrl = null, $otherCompanyBankId = null, \StructType\CurrencyTypesEntity $currency = null)
    {
        $this
            ->setBankId($bankId)
            ->setBankCode($bankCode)
            ->setAccountId($accountId)
            ->setIsOurBank($isOurBank)
            ->setPayerStatus($payerStatus)
            ->setIsInternetBanking($isInternetBanking)
            ->setTransferCommission($transferCommission)
            ->setOvertimeTransferCommission($overtimeTransferCommission)
            ->setEFTCommission($eFTCommission)
            ->setOvertimeEFTCommission($overtimeEFTCommission)
            ->setCardCommission($cardCommission)
            ->setATMCommission($aTMCommission)
            ->setIsCommission($isCommission)
            ->setIsActived($isActived)
            ->setIsDelete($isDelete)
            ->setBankName($bankName)
            ->setIban($iban)
            ->setAccountingCode($accountingCode)
            ->setUrl($url)
            ->setShortName($shortName)
            ->setImageUrl($imageUrl)
            ->setCardImageUrl($cardImageUrl)
            ->setOtherCompanyBankId($otherCompanyBankId)
            ->setCurrency($currency);
    }
    /**
     * Get BankId value
     * @return int
     */
    public function getBankId()
    {
        return $this->BankId;
    }
    /**
     * Set BankId value
     * @param int $bankId
     * @return \StructType\BanksEntity
     */
    public function setBankId($bankId = null)
    {
        // validation for constraint: int
        if (!is_null($bankId) && !(is_int($bankId) || ctype_digit($bankId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankId, true), gettype($bankId)), __LINE__);
        }
        $this->BankId = $bankId;
        return $this;
    }
    /**
     * Get BankCode value
     * @return int
     */
    public function getBankCode()
    {
        return $this->BankCode;
    }
    /**
     * Set BankCode value
     * @param int $bankCode
     * @return \StructType\BanksEntity
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: int
        if (!is_null($bankCode) && !(is_int($bankCode) || ctype_digit($bankCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        $this->BankCode = $bankCode;
        return $this;
    }
    /**
     * Get AccountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\BanksEntity
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get IsOurBank value
     * @return bool
     */
    public function getIsOurBank()
    {
        return $this->IsOurBank;
    }
    /**
     * Set IsOurBank value
     * @param bool $isOurBank
     * @return \StructType\BanksEntity
     */
    public function setIsOurBank($isOurBank = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOurBank) && !is_bool($isOurBank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOurBank, true), gettype($isOurBank)), __LINE__);
        }
        $this->IsOurBank = $isOurBank;
        return $this;
    }
    /**
     * Get PayerStatus value
     * @return bool
     */
    public function getPayerStatus()
    {
        return $this->PayerStatus;
    }
    /**
     * Set PayerStatus value
     * @param bool $payerStatus
     * @return \StructType\BanksEntity
     */
    public function setPayerStatus($payerStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($payerStatus) && !is_bool($payerStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payerStatus, true), gettype($payerStatus)), __LINE__);
        }
        $this->PayerStatus = $payerStatus;
        return $this;
    }
    /**
     * Get IsInternetBanking value
     * @return bool
     */
    public function getIsInternetBanking()
    {
        return $this->IsInternetBanking;
    }
    /**
     * Set IsInternetBanking value
     * @param bool $isInternetBanking
     * @return \StructType\BanksEntity
     */
    public function setIsInternetBanking($isInternetBanking = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInternetBanking) && !is_bool($isInternetBanking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInternetBanking, true), gettype($isInternetBanking)), __LINE__);
        }
        $this->IsInternetBanking = $isInternetBanking;
        return $this;
    }
    /**
     * Get TransferCommission value
     * @return float
     */
    public function getTransferCommission()
    {
        return $this->TransferCommission;
    }
    /**
     * Set TransferCommission value
     * @param float $transferCommission
     * @return \StructType\BanksEntity
     */
    public function setTransferCommission($transferCommission = null)
    {
        // validation for constraint: float
        if (!is_null($transferCommission) && !(is_float($transferCommission) || is_numeric($transferCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transferCommission, true), gettype($transferCommission)), __LINE__);
        }
        $this->TransferCommission = $transferCommission;
        return $this;
    }
    /**
     * Get OvertimeTransferCommission value
     * @return float
     */
    public function getOvertimeTransferCommission()
    {
        return $this->OvertimeTransferCommission;
    }
    /**
     * Set OvertimeTransferCommission value
     * @param float $overtimeTransferCommission
     * @return \StructType\BanksEntity
     */
    public function setOvertimeTransferCommission($overtimeTransferCommission = null)
    {
        // validation for constraint: float
        if (!is_null($overtimeTransferCommission) && !(is_float($overtimeTransferCommission) || is_numeric($overtimeTransferCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overtimeTransferCommission, true), gettype($overtimeTransferCommission)), __LINE__);
        }
        $this->OvertimeTransferCommission = $overtimeTransferCommission;
        return $this;
    }
    /**
     * Get EFTCommission value
     * @return float
     */
    public function getEFTCommission()
    {
        return $this->EFTCommission;
    }
    /**
     * Set EFTCommission value
     * @param float $eFTCommission
     * @return \StructType\BanksEntity
     */
    public function setEFTCommission($eFTCommission = null)
    {
        // validation for constraint: float
        if (!is_null($eFTCommission) && !(is_float($eFTCommission) || is_numeric($eFTCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eFTCommission, true), gettype($eFTCommission)), __LINE__);
        }
        $this->EFTCommission = $eFTCommission;
        return $this;
    }
    /**
     * Get OvertimeEFTCommission value
     * @return float
     */
    public function getOvertimeEFTCommission()
    {
        return $this->OvertimeEFTCommission;
    }
    /**
     * Set OvertimeEFTCommission value
     * @param float $overtimeEFTCommission
     * @return \StructType\BanksEntity
     */
    public function setOvertimeEFTCommission($overtimeEFTCommission = null)
    {
        // validation for constraint: float
        if (!is_null($overtimeEFTCommission) && !(is_float($overtimeEFTCommission) || is_numeric($overtimeEFTCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overtimeEFTCommission, true), gettype($overtimeEFTCommission)), __LINE__);
        }
        $this->OvertimeEFTCommission = $overtimeEFTCommission;
        return $this;
    }
    /**
     * Get CardCommission value
     * @return float
     */
    public function getCardCommission()
    {
        return $this->CardCommission;
    }
    /**
     * Set CardCommission value
     * @param float $cardCommission
     * @return \StructType\BanksEntity
     */
    public function setCardCommission($cardCommission = null)
    {
        // validation for constraint: float
        if (!is_null($cardCommission) && !(is_float($cardCommission) || is_numeric($cardCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cardCommission, true), gettype($cardCommission)), __LINE__);
        }
        $this->CardCommission = $cardCommission;
        return $this;
    }
    /**
     * Get ATMCommission value
     * @return float
     */
    public function getATMCommission()
    {
        return $this->ATMCommission;
    }
    /**
     * Set ATMCommission value
     * @param float $aTMCommission
     * @return \StructType\BanksEntity
     */
    public function setATMCommission($aTMCommission = null)
    {
        // validation for constraint: float
        if (!is_null($aTMCommission) && !(is_float($aTMCommission) || is_numeric($aTMCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aTMCommission, true), gettype($aTMCommission)), __LINE__);
        }
        $this->ATMCommission = $aTMCommission;
        return $this;
    }
    /**
     * Get IsCommission value
     * @return bool
     */
    public function getIsCommission()
    {
        return $this->IsCommission;
    }
    /**
     * Set IsCommission value
     * @param bool $isCommission
     * @return \StructType\BanksEntity
     */
    public function setIsCommission($isCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommission) && !is_bool($isCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommission, true), gettype($isCommission)), __LINE__);
        }
        $this->IsCommission = $isCommission;
        return $this;
    }
    /**
     * Get IsActived value
     * @return bool
     */
    public function getIsActived()
    {
        return $this->IsActived;
    }
    /**
     * Set IsActived value
     * @param bool $isActived
     * @return \StructType\BanksEntity
     */
    public function setIsActived($isActived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActived) && !is_bool($isActived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActived, true), gettype($isActived)), __LINE__);
        }
        $this->IsActived = $isActived;
        return $this;
    }
    /**
     * Get IsDelete value
     * @return bool
     */
    public function getIsDelete()
    {
        return $this->IsDelete;
    }
    /**
     * Set IsDelete value
     * @param bool $isDelete
     * @return \StructType\BanksEntity
     */
    public function setIsDelete($isDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDelete) && !is_bool($isDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDelete, true), gettype($isDelete)), __LINE__);
        }
        $this->IsDelete = $isDelete;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\BanksEntity
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get Iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->Iban;
    }
    /**
     * Set Iban value
     * @param string $iban
     * @return \StructType\BanksEntity
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        $this->Iban = $iban;
        return $this;
    }
    /**
     * Get AccountingCode value
     * @return string|null
     */
    public function getAccountingCode()
    {
        return $this->AccountingCode;
    }
    /**
     * Set AccountingCode value
     * @param string $accountingCode
     * @return \StructType\BanksEntity
     */
    public function setAccountingCode($accountingCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountingCode) && !is_string($accountingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountingCode, true), gettype($accountingCode)), __LINE__);
        }
        $this->AccountingCode = $accountingCode;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\BanksEntity
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get ShortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->ShortName;
    }
    /**
     * Set ShortName value
     * @param string $shortName
     * @return \StructType\BanksEntity
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortName, true), gettype($shortName)), __LINE__);
        }
        $this->ShortName = $shortName;
        return $this;
    }
    /**
     * Get ImageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->ImageUrl;
    }
    /**
     * Set ImageUrl value
     * @param string $imageUrl
     * @return \StructType\BanksEntity
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        $this->ImageUrl = $imageUrl;
        return $this;
    }
    /**
     * Get CardImageUrl value
     * @return string|null
     */
    public function getCardImageUrl()
    {
        return $this->CardImageUrl;
    }
    /**
     * Set CardImageUrl value
     * @param string $cardImageUrl
     * @return \StructType\BanksEntity
     */
    public function setCardImageUrl($cardImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($cardImageUrl) && !is_string($cardImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardImageUrl, true), gettype($cardImageUrl)), __LINE__);
        }
        $this->CardImageUrl = $cardImageUrl;
        return $this;
    }
    /**
     * Get OtherCompanyBankId value
     * @return string|null
     */
    public function getOtherCompanyBankId()
    {
        return $this->OtherCompanyBankId;
    }
    /**
     * Set OtherCompanyBankId value
     * @param string $otherCompanyBankId
     * @return \StructType\BanksEntity
     */
    public function setOtherCompanyBankId($otherCompanyBankId = null)
    {
        // validation for constraint: string
        if (!is_null($otherCompanyBankId) && !is_string($otherCompanyBankId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherCompanyBankId, true), gettype($otherCompanyBankId)), __LINE__);
        }
        $this->OtherCompanyBankId = $otherCompanyBankId;
        return $this;
    }
    /**
     * Get Currency value
     * @return \StructType\CurrencyTypesEntity|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param \StructType\CurrencyTypesEntity $currency
     * @return \StructType\BanksEntity
     */
    public function setCurrency(\StructType\CurrencyTypesEntity $currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BanksEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
