<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountsEntity StructType
 * @subpackage Structs
 */
class AccountsEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The AccountTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeId;
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountCode;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Phone;
    /**
     * The SecurityQuestionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SecurityQuestionID;
    /**
     * The VerificationTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VerificationTypeId;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BirthDate;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastLogonDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastLogonDate;
    /**
     * The IsMailVerificated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMailVerificated;
    /**
     * The IsSmsVerificated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSmsVerificated;
    /**
     * The IsActived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActived;
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsIpRestriction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsIpRestriction;
    /**
     * The IsIssuerAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsIssuerAccount;
    /**
     * The ConfirmTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConfirmTypeId;
    /**
     * The IsConfirm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsConfirm;
    /**
     * The IsMobileActivated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMobileActivated;
    /**
     * The Step
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Step;
    /**
     * The IsNameChanged
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNameChanged;
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The AccountPass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountPass;
    /**
     * The Name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name1;
    /**
     * The Name2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name2;
    /**
     * The Mail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mail;
    /**
     * The SecurityResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecurityResponse;
    /**
     * The CreateUserIp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateUserIp;
    /**
     * The ContractNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractNo;
    /**
     * The AccountPassCase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountPassCase;
    /**
     * The TokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TokenId;
    /**
     * The AccountNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNo;
    /**
     * The AccountVerificationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountVerificationName;
    /**
     * The AccountTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountTypesEntity
     */
    public $AccountTypes;
    /**
     * The AccountVerification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VerificationTypesEntity
     */
    public $AccountVerification;
    /**
     * Constructor method for AccountsEntity
     * @uses AccountsEntity::setId()
     * @uses AccountsEntity::setAccountTypeId()
     * @uses AccountsEntity::setAccountCode()
     * @uses AccountsEntity::setPhone()
     * @uses AccountsEntity::setSecurityQuestionID()
     * @uses AccountsEntity::setVerificationTypeId()
     * @uses AccountsEntity::setBirthDate()
     * @uses AccountsEntity::setCreateDate()
     * @uses AccountsEntity::setLastLogonDate()
     * @uses AccountsEntity::setIsMailVerificated()
     * @uses AccountsEntity::setIsSmsVerificated()
     * @uses AccountsEntity::setIsActived()
     * @uses AccountsEntity::setIsDeleted()
     * @uses AccountsEntity::setIsIpRestriction()
     * @uses AccountsEntity::setIsIssuerAccount()
     * @uses AccountsEntity::setConfirmTypeId()
     * @uses AccountsEntity::setIsConfirm()
     * @uses AccountsEntity::setIsMobileActivated()
     * @uses AccountsEntity::setStep()
     * @uses AccountsEntity::setIsNameChanged()
     * @uses AccountsEntity::setAccountName()
     * @uses AccountsEntity::setAccountPass()
     * @uses AccountsEntity::setName1()
     * @uses AccountsEntity::setName2()
     * @uses AccountsEntity::setMail()
     * @uses AccountsEntity::setSecurityResponse()
     * @uses AccountsEntity::setCreateUserIp()
     * @uses AccountsEntity::setContractNo()
     * @uses AccountsEntity::setAccountPassCase()
     * @uses AccountsEntity::setTokenId()
     * @uses AccountsEntity::setAccountNo()
     * @uses AccountsEntity::setAccountVerificationName()
     * @uses AccountsEntity::setAccountTypes()
     * @uses AccountsEntity::setAccountVerification()
     * @param int $id
     * @param int $accountTypeId
     * @param int $accountCode
     * @param int $phone
     * @param int $securityQuestionID
     * @param int $verificationTypeId
     * @param string $birthDate
     * @param string $createDate
     * @param string $lastLogonDate
     * @param bool $isMailVerificated
     * @param bool $isSmsVerificated
     * @param bool $isActived
     * @param bool $isDeleted
     * @param bool $isIpRestriction
     * @param bool $isIssuerAccount
     * @param int $confirmTypeId
     * @param bool $isConfirm
     * @param bool $isMobileActivated
     * @param int $step
     * @param bool $isNameChanged
     * @param string $accountName
     * @param string $accountPass
     * @param string $name1
     * @param string $name2
     * @param string $mail
     * @param string $securityResponse
     * @param string $createUserIp
     * @param string $contractNo
     * @param string $accountPassCase
     * @param string $tokenId
     * @param string $accountNo
     * @param string $accountVerificationName
     * @param \StructType\AccountTypesEntity $accountTypes
     * @param \StructType\VerificationTypesEntity $accountVerification
     */
    public function __construct($id = null, $accountTypeId = null, $accountCode = null, $phone = null, $securityQuestionID = null, $verificationTypeId = null, $birthDate = null, $createDate = null, $lastLogonDate = null, $isMailVerificated = null, $isSmsVerificated = null, $isActived = null, $isDeleted = null, $isIpRestriction = null, $isIssuerAccount = null, $confirmTypeId = null, $isConfirm = null, $isMobileActivated = null, $step = null, $isNameChanged = null, $accountName = null, $accountPass = null, $name1 = null, $name2 = null, $mail = null, $securityResponse = null, $createUserIp = null, $contractNo = null, $accountPassCase = null, $tokenId = null, $accountNo = null, $accountVerificationName = null, \StructType\AccountTypesEntity $accountTypes = null, \StructType\VerificationTypesEntity $accountVerification = null)
    {
        $this
            ->setId($id)
            ->setAccountTypeId($accountTypeId)
            ->setAccountCode($accountCode)
            ->setPhone($phone)
            ->setSecurityQuestionID($securityQuestionID)
            ->setVerificationTypeId($verificationTypeId)
            ->setBirthDate($birthDate)
            ->setCreateDate($createDate)
            ->setLastLogonDate($lastLogonDate)
            ->setIsMailVerificated($isMailVerificated)
            ->setIsSmsVerificated($isSmsVerificated)
            ->setIsActived($isActived)
            ->setIsDeleted($isDeleted)
            ->setIsIpRestriction($isIpRestriction)
            ->setIsIssuerAccount($isIssuerAccount)
            ->setConfirmTypeId($confirmTypeId)
            ->setIsConfirm($isConfirm)
            ->setIsMobileActivated($isMobileActivated)
            ->setStep($step)
            ->setIsNameChanged($isNameChanged)
            ->setAccountName($accountName)
            ->setAccountPass($accountPass)
            ->setName1($name1)
            ->setName2($name2)
            ->setMail($mail)
            ->setSecurityResponse($securityResponse)
            ->setCreateUserIp($createUserIp)
            ->setContractNo($contractNo)
            ->setAccountPassCase($accountPassCase)
            ->setTokenId($tokenId)
            ->setAccountNo($accountNo)
            ->setAccountVerificationName($accountVerificationName)
            ->setAccountTypes($accountTypes)
            ->setAccountVerification($accountVerification);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\AccountsEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get AccountTypeId value
     * @return int
     */
    public function getAccountTypeId()
    {
        return $this->AccountTypeId;
    }
    /**
     * Set AccountTypeId value
     * @param int $accountTypeId
     * @return \StructType\AccountsEntity
     */
    public function setAccountTypeId($accountTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeId) && !(is_int($accountTypeId) || ctype_digit($accountTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountTypeId, true), gettype($accountTypeId)), __LINE__);
        }
        $this->AccountTypeId = $accountTypeId;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return int
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param int $accountCode
     * @return \StructType\AccountsEntity
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: int
        if (!is_null($accountCode) && !(is_int($accountCode) || ctype_digit($accountCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get Phone value
     * @return int
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param int $phone
     * @return \StructType\AccountsEntity
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: int
        if (!is_null($phone) && !(is_int($phone) || ctype_digit($phone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get SecurityQuestionID value
     * @return int
     */
    public function getSecurityQuestionID()
    {
        return $this->SecurityQuestionID;
    }
    /**
     * Set SecurityQuestionID value
     * @param int $securityQuestionID
     * @return \StructType\AccountsEntity
     */
    public function setSecurityQuestionID($securityQuestionID = null)
    {
        // validation for constraint: int
        if (!is_null($securityQuestionID) && !(is_int($securityQuestionID) || ctype_digit($securityQuestionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($securityQuestionID, true), gettype($securityQuestionID)), __LINE__);
        }
        $this->SecurityQuestionID = $securityQuestionID;
        return $this;
    }
    /**
     * Get VerificationTypeId value
     * @return int
     */
    public function getVerificationTypeId()
    {
        return $this->VerificationTypeId;
    }
    /**
     * Set VerificationTypeId value
     * @param int $verificationTypeId
     * @return \StructType\AccountsEntity
     */
    public function setVerificationTypeId($verificationTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($verificationTypeId) && !(is_int($verificationTypeId) || ctype_digit($verificationTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verificationTypeId, true), gettype($verificationTypeId)), __LINE__);
        }
        $this->VerificationTypeId = $verificationTypeId;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\AccountsEntity
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\AccountsEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastLogonDate value
     * @return string
     */
    public function getLastLogonDate()
    {
        return $this->LastLogonDate;
    }
    /**
     * Set LastLogonDate value
     * @param string $lastLogonDate
     * @return \StructType\AccountsEntity
     */
    public function setLastLogonDate($lastLogonDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastLogonDate) && !is_string($lastLogonDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastLogonDate, true), gettype($lastLogonDate)), __LINE__);
        }
        $this->LastLogonDate = $lastLogonDate;
        return $this;
    }
    /**
     * Get IsMailVerificated value
     * @return bool
     */
    public function getIsMailVerificated()
    {
        return $this->IsMailVerificated;
    }
    /**
     * Set IsMailVerificated value
     * @param bool $isMailVerificated
     * @return \StructType\AccountsEntity
     */
    public function setIsMailVerificated($isMailVerificated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMailVerificated) && !is_bool($isMailVerificated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMailVerificated, true), gettype($isMailVerificated)), __LINE__);
        }
        $this->IsMailVerificated = $isMailVerificated;
        return $this;
    }
    /**
     * Get IsSmsVerificated value
     * @return bool
     */
    public function getIsSmsVerificated()
    {
        return $this->IsSmsVerificated;
    }
    /**
     * Set IsSmsVerificated value
     * @param bool $isSmsVerificated
     * @return \StructType\AccountsEntity
     */
    public function setIsSmsVerificated($isSmsVerificated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSmsVerificated) && !is_bool($isSmsVerificated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSmsVerificated, true), gettype($isSmsVerificated)), __LINE__);
        }
        $this->IsSmsVerificated = $isSmsVerificated;
        return $this;
    }
    /**
     * Get IsActived value
     * @return bool
     */
    public function getIsActived()
    {
        return $this->IsActived;
    }
    /**
     * Set IsActived value
     * @param bool $isActived
     * @return \StructType\AccountsEntity
     */
    public function setIsActived($isActived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActived) && !is_bool($isActived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActived, true), gettype($isActived)), __LINE__);
        }
        $this->IsActived = $isActived;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\AccountsEntity
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get IsIpRestriction value
     * @return bool
     */
    public function getIsIpRestriction()
    {
        return $this->IsIpRestriction;
    }
    /**
     * Set IsIpRestriction value
     * @param bool $isIpRestriction
     * @return \StructType\AccountsEntity
     */
    public function setIsIpRestriction($isIpRestriction = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIpRestriction) && !is_bool($isIpRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIpRestriction, true), gettype($isIpRestriction)), __LINE__);
        }
        $this->IsIpRestriction = $isIpRestriction;
        return $this;
    }
    /**
     * Get IsIssuerAccount value
     * @return bool
     */
    public function getIsIssuerAccount()
    {
        return $this->IsIssuerAccount;
    }
    /**
     * Set IsIssuerAccount value
     * @param bool $isIssuerAccount
     * @return \StructType\AccountsEntity
     */
    public function setIsIssuerAccount($isIssuerAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIssuerAccount) && !is_bool($isIssuerAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIssuerAccount, true), gettype($isIssuerAccount)), __LINE__);
        }
        $this->IsIssuerAccount = $isIssuerAccount;
        return $this;
    }
    /**
     * Get ConfirmTypeId value
     * @return int
     */
    public function getConfirmTypeId()
    {
        return $this->ConfirmTypeId;
    }
    /**
     * Set ConfirmTypeId value
     * @param int $confirmTypeId
     * @return \StructType\AccountsEntity
     */
    public function setConfirmTypeId($confirmTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($confirmTypeId) && !(is_int($confirmTypeId) || ctype_digit($confirmTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confirmTypeId, true), gettype($confirmTypeId)), __LINE__);
        }
        $this->ConfirmTypeId = $confirmTypeId;
        return $this;
    }
    /**
     * Get IsConfirm value
     * @return bool
     */
    public function getIsConfirm()
    {
        return $this->IsConfirm;
    }
    /**
     * Set IsConfirm value
     * @param bool $isConfirm
     * @return \StructType\AccountsEntity
     */
    public function setIsConfirm($isConfirm = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirm) && !is_bool($isConfirm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirm, true), gettype($isConfirm)), __LINE__);
        }
        $this->IsConfirm = $isConfirm;
        return $this;
    }
    /**
     * Get IsMobileActivated value
     * @return bool
     */
    public function getIsMobileActivated()
    {
        return $this->IsMobileActivated;
    }
    /**
     * Set IsMobileActivated value
     * @param bool $isMobileActivated
     * @return \StructType\AccountsEntity
     */
    public function setIsMobileActivated($isMobileActivated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMobileActivated) && !is_bool($isMobileActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMobileActivated, true), gettype($isMobileActivated)), __LINE__);
        }
        $this->IsMobileActivated = $isMobileActivated;
        return $this;
    }
    /**
     * Get Step value
     * @return int
     */
    public function getStep()
    {
        return $this->Step;
    }
    /**
     * Set Step value
     * @param int $step
     * @return \StructType\AccountsEntity
     */
    public function setStep($step = null)
    {
        // validation for constraint: int
        if (!is_null($step) && !(is_int($step) || ctype_digit($step))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($step, true), gettype($step)), __LINE__);
        }
        $this->Step = $step;
        return $this;
    }
    /**
     * Get IsNameChanged value
     * @return bool
     */
    public function getIsNameChanged()
    {
        return $this->IsNameChanged;
    }
    /**
     * Set IsNameChanged value
     * @param bool $isNameChanged
     * @return \StructType\AccountsEntity
     */
    public function setIsNameChanged($isNameChanged = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNameChanged) && !is_bool($isNameChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNameChanged, true), gettype($isNameChanged)), __LINE__);
        }
        $this->IsNameChanged = $isNameChanged;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\AccountsEntity
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get AccountPass value
     * @return string|null
     */
    public function getAccountPass()
    {
        return $this->AccountPass;
    }
    /**
     * Set AccountPass value
     * @param string $accountPass
     * @return \StructType\AccountsEntity
     */
    public function setAccountPass($accountPass = null)
    {
        // validation for constraint: string
        if (!is_null($accountPass) && !is_string($accountPass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountPass, true), gettype($accountPass)), __LINE__);
        }
        $this->AccountPass = $accountPass;
        return $this;
    }
    /**
     * Get Name1 value
     * @return string|null
     */
    public function getName1()
    {
        return $this->Name1;
    }
    /**
     * Set Name1 value
     * @param string $name1
     * @return \StructType\AccountsEntity
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->Name1 = $name1;
        return $this;
    }
    /**
     * Get Name2 value
     * @return string|null
     */
    public function getName2()
    {
        return $this->Name2;
    }
    /**
     * Set Name2 value
     * @param string $name2
     * @return \StructType\AccountsEntity
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        $this->Name2 = $name2;
        return $this;
    }
    /**
     * Get Mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->Mail;
    }
    /**
     * Set Mail value
     * @param string $mail
     * @return \StructType\AccountsEntity
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        $this->Mail = $mail;
        return $this;
    }
    /**
     * Get SecurityResponse value
     * @return string|null
     */
    public function getSecurityResponse()
    {
        return $this->SecurityResponse;
    }
    /**
     * Set SecurityResponse value
     * @param string $securityResponse
     * @return \StructType\AccountsEntity
     */
    public function setSecurityResponse($securityResponse = null)
    {
        // validation for constraint: string
        if (!is_null($securityResponse) && !is_string($securityResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityResponse, true), gettype($securityResponse)), __LINE__);
        }
        $this->SecurityResponse = $securityResponse;
        return $this;
    }
    /**
     * Get CreateUserIp value
     * @return string|null
     */
    public function getCreateUserIp()
    {
        return $this->CreateUserIp;
    }
    /**
     * Set CreateUserIp value
     * @param string $createUserIp
     * @return \StructType\AccountsEntity
     */
    public function setCreateUserIp($createUserIp = null)
    {
        // validation for constraint: string
        if (!is_null($createUserIp) && !is_string($createUserIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserIp, true), gettype($createUserIp)), __LINE__);
        }
        $this->CreateUserIp = $createUserIp;
        return $this;
    }
    /**
     * Get ContractNo value
     * @return string|null
     */
    public function getContractNo()
    {
        return $this->ContractNo;
    }
    /**
     * Set ContractNo value
     * @param string $contractNo
     * @return \StructType\AccountsEntity
     */
    public function setContractNo($contractNo = null)
    {
        // validation for constraint: string
        if (!is_null($contractNo) && !is_string($contractNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractNo, true), gettype($contractNo)), __LINE__);
        }
        $this->ContractNo = $contractNo;
        return $this;
    }
    /**
     * Get AccountPassCase value
     * @return string|null
     */
    public function getAccountPassCase()
    {
        return $this->AccountPassCase;
    }
    /**
     * Set AccountPassCase value
     * @param string $accountPassCase
     * @return \StructType\AccountsEntity
     */
    public function setAccountPassCase($accountPassCase = null)
    {
        // validation for constraint: string
        if (!is_null($accountPassCase) && !is_string($accountPassCase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountPassCase, true), gettype($accountPassCase)), __LINE__);
        }
        $this->AccountPassCase = $accountPassCase;
        return $this;
    }
    /**
     * Get TokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->TokenId;
    }
    /**
     * Set TokenId value
     * @param string $tokenId
     * @return \StructType\AccountsEntity
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->TokenId = $tokenId;
        return $this;
    }
    /**
     * Get AccountNo value
     * @return string|null
     */
    public function getAccountNo()
    {
        return $this->AccountNo;
    }
    /**
     * Set AccountNo value
     * @param string $accountNo
     * @return \StructType\AccountsEntity
     */
    public function setAccountNo($accountNo = null)
    {
        // validation for constraint: string
        if (!is_null($accountNo) && !is_string($accountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNo, true), gettype($accountNo)), __LINE__);
        }
        $this->AccountNo = $accountNo;
        return $this;
    }
    /**
     * Get AccountVerificationName value
     * @return string|null
     */
    public function getAccountVerificationName()
    {
        return $this->AccountVerificationName;
    }
    /**
     * Set AccountVerificationName value
     * @param string $accountVerificationName
     * @return \StructType\AccountsEntity
     */
    public function setAccountVerificationName($accountVerificationName = null)
    {
        // validation for constraint: string
        if (!is_null($accountVerificationName) && !is_string($accountVerificationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountVerificationName, true), gettype($accountVerificationName)), __LINE__);
        }
        $this->AccountVerificationName = $accountVerificationName;
        return $this;
    }
    /**
     * Get AccountTypes value
     * @return \StructType\AccountTypesEntity|null
     */
    public function getAccountTypes()
    {
        return $this->AccountTypes;
    }
    /**
     * Set AccountTypes value
     * @param \StructType\AccountTypesEntity $accountTypes
     * @return \StructType\AccountsEntity
     */
    public function setAccountTypes(\StructType\AccountTypesEntity $accountTypes = null)
    {
        $this->AccountTypes = $accountTypes;
        return $this;
    }
    /**
     * Get AccountVerification value
     * @return \StructType\VerificationTypesEntity|null
     */
    public function getAccountVerification()
    {
        return $this->AccountVerification;
    }
    /**
     * Set AccountVerification value
     * @param \StructType\VerificationTypesEntity $accountVerification
     * @return \StructType\AccountsEntity
     */
    public function setAccountVerification(\StructType\VerificationTypesEntity $accountVerification = null)
    {
        $this->AccountVerification = $accountVerification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
