<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountPersonelIdentityControl StructType
 * @subpackage Structs
 */
class AccountPersonelIdentityControl extends AbstractStructBase
{
    /**
     * The TcNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TcNo;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The TcSerialNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TcSerialNo;
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * Constructor method for AccountPersonelIdentityControl
     * @uses AccountPersonelIdentityControl::setTcNo()
     * @uses AccountPersonelIdentityControl::setTokenId()
     * @uses AccountPersonelIdentityControl::setTcSerialNo()
     * @uses AccountPersonelIdentityControl::setBirthDate()
     * @param int $tcNo
     * @param string $tokenId
     * @param string $tcSerialNo
     * @param string $birthDate
     */
    public function __construct($tcNo = null, $tokenId = null, $tcSerialNo = null, $birthDate = null)
    {
        $this
            ->setTcNo($tcNo)
            ->setTokenId($tokenId)
            ->setTcSerialNo($tcSerialNo)
            ->setBirthDate($birthDate);
    }
    /**
     * Get TcNo value
     * @return int
     */
    public function getTcNo()
    {
        return $this->TcNo;
    }
    /**
     * Set TcNo value
     * @param int $tcNo
     * @return \StructType\AccountPersonelIdentityControl
     */
    public function setTcNo($tcNo = null)
    {
        // validation for constraint: int
        if (!is_null($tcNo) && !(is_int($tcNo) || ctype_digit($tcNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tcNo, true), gettype($tcNo)), __LINE__);
        }
        $this->TcNo = $tcNo;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\AccountPersonelIdentityControl
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get TcSerialNo value
     * @return string|null
     */
    public function getTcSerialNo()
    {
        return $this->TcSerialNo;
    }
    /**
     * Set TcSerialNo value
     * @param string $tcSerialNo
     * @return \StructType\AccountPersonelIdentityControl
     */
    public function setTcSerialNo($tcSerialNo = null)
    {
        // validation for constraint: string
        if (!is_null($tcSerialNo) && !is_string($tcSerialNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tcSerialNo, true), gettype($tcSerialNo)), __LINE__);
        }
        $this->TcSerialNo = $tcSerialNo;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\AccountPersonelIdentityControl
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountPersonelIdentityControl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
