<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Replace ServiceType
 * @subpackage Services
 */
class Replace extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\StructType\AuthHeader $authHeader, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ReplacePassword
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReplacePassword $parameters
     * @return \StructType\ReplacePasswordResponse|bool
     */
    public function ReplacePassword(\StructType\ReplacePassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReplacePassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReplaceMail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReplaceMail $parameters
     * @return \StructType\ReplaceMailResponse|bool
     */
    public function ReplaceMail(\StructType\ReplaceMail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReplaceMail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReplaceMailValidateOldMail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReplaceMailValidateOldMail $parameters
     * @return \StructType\ReplaceMailValidateOldMailResponse|bool
     */
    public function ReplaceMailValidateOldMail(\StructType\ReplaceMailValidateOldMail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReplaceMailValidateOldMail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReplaceMailValidateNewMail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReplaceMailValidateNewMail $parameters
     * @return \StructType\ReplaceMailValidateNewMailResponse|bool
     */
    public function ReplaceMailValidateNewMail(\StructType\ReplaceMailValidateNewMail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReplaceMailValidateNewMail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReplacePhone
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReplacePhone $parameters
     * @return \StructType\ReplacePhoneResponse|bool
     */
    public function ReplacePhone(\StructType\ReplacePhone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReplacePhone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReplacePhoneValidateOldPhone
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReplacePhoneValidateOldPhone $parameters
     * @return \StructType\ReplacePhoneValidateOldPhoneResponse|bool
     */
    public function ReplacePhoneValidateOldPhone(\StructType\ReplacePhoneValidateOldPhone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReplacePhoneValidateOldPhone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReplacePhoneValidateNewPhone
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReplacePhoneValidateNewPhone $parameters
     * @return \StructType\ReplacePhoneValidateNewPhoneResponse|bool
     */
    public function ReplacePhoneValidateNewPhone(\StructType\ReplacePhoneValidateNewPhone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReplacePhoneValidateNewPhone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReplaceMailResponse|\StructType\ReplaceMailValidateNewMailResponse|\StructType\ReplaceMailValidateOldMailResponse|\StructType\ReplacePasswordResponse|\StructType\ReplacePhoneResponse|\StructType\ReplacePhoneValidateNewPhoneResponse|\StructType\ReplacePhoneValidateOldPhoneResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
