<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Forget ServiceType
 * @subpackage Services
 */
class Forget extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\StructType\AuthHeader $authHeader, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ForgetPasswordwithdMailandMobile
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ForgetPasswordwithdMailandMobile $parameters
     * @return \StructType\ForgetPasswordwithdMailandMobileResponse|bool
     */
    public function ForgetPasswordwithdMailandMobile(\StructType\ForgetPasswordwithdMailandMobile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ForgetPasswordwithdMailandMobile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ForgetPassWithdMailandMobile
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ForgetPassWithdMailandMobile $parameters
     * @return \StructType\ForgetPassWithdMailandMobileResponse|bool
     */
    public function ForgetPassWithdMailandMobile(\StructType\ForgetPassWithdMailandMobile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ForgetPassWithdMailandMobile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ForgetPasswordwithdMailandMobileControl
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ForgetPasswordwithdMailandMobileControl $parameters
     * @return \StructType\ForgetPasswordwithdMailandMobileControlResponse|bool
     */
    public function ForgetPasswordwithdMailandMobileControl(\StructType\ForgetPasswordwithdMailandMobileControl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ForgetPasswordwithdMailandMobileControl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ForgetPasswordwithdMailandMobileValidateCode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ForgetPasswordwithdMailandMobileValidateCode $parameters
     * @return \StructType\ForgetPasswordwithdMailandMobileValidateCodeResponse|bool
     */
    public function ForgetPasswordwithdMailandMobileValidateCode(\StructType\ForgetPasswordwithdMailandMobileValidateCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ForgetPasswordwithdMailandMobileValidateCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ForgetPasswordwithMailandMobilePassword
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ForgetPasswordwithMailandMobilePassword $parameters
     * @return \StructType\ForgetPasswordwithMailandMobilePasswordResponse|bool
     */
    public function ForgetPasswordwithMailandMobilePassword(\StructType\ForgetPasswordwithMailandMobilePassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ForgetPasswordwithMailandMobilePassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ForgetPasswordMailandMobileReSendSms
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ForgetPasswordMailandMobileReSendSms $parameters
     * @return \StructType\ForgetPasswordMailandMobileReSendSmsResponse|bool
     */
    public function ForgetPasswordMailandMobileReSendSms(\StructType\ForgetPasswordMailandMobileReSendSms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ForgetPasswordMailandMobileReSendSms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ForgetPassWithdMailandMobileResponse|\StructType\ForgetPasswordMailandMobileReSendSmsResponse|\StructType\ForgetPasswordwithdMailandMobileControlResponse|\StructType\ForgetPasswordwithdMailandMobileResponse|\StructType\ForgetPasswordwithdMailandMobileValidateCodeResponse|\StructType\ForgetPasswordwithMailandMobilePasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
