<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShoppingAdditionDetailEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfShoppingAdditionDetailEntity extends AbstractStructArrayBase
{
    /**
     * The ShoppingAdditionDetailEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShoppingAdditionDetailEntity[]
     */
    public $ShoppingAdditionDetailEntity;
    /**
     * Constructor method for ArrayOfShoppingAdditionDetailEntity
     * @uses ArrayOfShoppingAdditionDetailEntity::setShoppingAdditionDetailEntity()
     * @param \StructType\ShoppingAdditionDetailEntity[] $shoppingAdditionDetailEntity
     */
    public function __construct(array $shoppingAdditionDetailEntity = array())
    {
        $this
            ->setShoppingAdditionDetailEntity($shoppingAdditionDetailEntity);
    }
    /**
     * Get ShoppingAdditionDetailEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShoppingAdditionDetailEntity[]|null
     */
    public function getShoppingAdditionDetailEntity()
    {
        return isset($this->ShoppingAdditionDetailEntity) ? $this->ShoppingAdditionDetailEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShoppingAdditionDetailEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShoppingAdditionDetailEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShoppingAdditionDetailEntityForArrayConstraintsFromSetShoppingAdditionDetailEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfShoppingAdditionDetailEntityShoppingAdditionDetailEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfShoppingAdditionDetailEntityShoppingAdditionDetailEntityItem instanceof \StructType\ShoppingAdditionDetailEntity) {
                $invalidValues[] = is_object($arrayOfShoppingAdditionDetailEntityShoppingAdditionDetailEntityItem) ? get_class($arrayOfShoppingAdditionDetailEntityShoppingAdditionDetailEntityItem) : sprintf('%s(%s)', gettype($arrayOfShoppingAdditionDetailEntityShoppingAdditionDetailEntityItem), var_export($arrayOfShoppingAdditionDetailEntityShoppingAdditionDetailEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShoppingAdditionDetailEntity property can only contain items of type \StructType\ShoppingAdditionDetailEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShoppingAdditionDetailEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingAdditionDetailEntity[] $shoppingAdditionDetailEntity
     * @return \ArrayType\ArrayOfShoppingAdditionDetailEntity
     */
    public function setShoppingAdditionDetailEntity(array $shoppingAdditionDetailEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($shoppingAdditionDetailEntityArrayErrorMessage = self::validateShoppingAdditionDetailEntityForArrayConstraintsFromSetShoppingAdditionDetailEntity($shoppingAdditionDetailEntity))) {
            throw new \InvalidArgumentException($shoppingAdditionDetailEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($shoppingAdditionDetailEntity) || (is_array($shoppingAdditionDetailEntity) && empty($shoppingAdditionDetailEntity))) {
            unset($this->ShoppingAdditionDetailEntity);
        } else {
            $this->ShoppingAdditionDetailEntity = $shoppingAdditionDetailEntity;
        }
        return $this;
    }
    /**
     * Add item to ShoppingAdditionDetailEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingAdditionDetailEntity $item
     * @return \ArrayType\ArrayOfShoppingAdditionDetailEntity
     */
    public function addToShoppingAdditionDetailEntity(\StructType\ShoppingAdditionDetailEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShoppingAdditionDetailEntity) {
            throw new \InvalidArgumentException(sprintf('The ShoppingAdditionDetailEntity property can only contain items of type \StructType\ShoppingAdditionDetailEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShoppingAdditionDetailEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ShoppingAdditionDetailEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ShoppingAdditionDetailEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ShoppingAdditionDetailEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ShoppingAdditionDetailEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ShoppingAdditionDetailEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShoppingAdditionDetailEntity
     */
    public function getAttributeName()
    {
        return 'ShoppingAdditionDetailEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfShoppingAdditionDetailEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
