<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMessagesEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfMessagesEntity extends AbstractStructArrayBase
{
    /**
     * The MessagesEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MessagesEntity[]
     */
    public $MessagesEntity;
    /**
     * Constructor method for ArrayOfMessagesEntity
     * @uses ArrayOfMessagesEntity::setMessagesEntity()
     * @param \StructType\MessagesEntity[] $messagesEntity
     */
    public function __construct(array $messagesEntity = array())
    {
        $this
            ->setMessagesEntity($messagesEntity);
    }
    /**
     * Get MessagesEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MessagesEntity[]|null
     */
    public function getMessagesEntity()
    {
        return isset($this->MessagesEntity) ? $this->MessagesEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMessagesEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessagesEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessagesEntityForArrayConstraintsFromSetMessagesEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMessagesEntityMessagesEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfMessagesEntityMessagesEntityItem instanceof \StructType\MessagesEntity) {
                $invalidValues[] = is_object($arrayOfMessagesEntityMessagesEntityItem) ? get_class($arrayOfMessagesEntityMessagesEntityItem) : sprintf('%s(%s)', gettype($arrayOfMessagesEntityMessagesEntityItem), var_export($arrayOfMessagesEntityMessagesEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MessagesEntity property can only contain items of type \StructType\MessagesEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MessagesEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MessagesEntity[] $messagesEntity
     * @return \ArrayType\ArrayOfMessagesEntity
     */
    public function setMessagesEntity(array $messagesEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($messagesEntityArrayErrorMessage = self::validateMessagesEntityForArrayConstraintsFromSetMessagesEntity($messagesEntity))) {
            throw new \InvalidArgumentException($messagesEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($messagesEntity) || (is_array($messagesEntity) && empty($messagesEntity))) {
            unset($this->MessagesEntity);
        } else {
            $this->MessagesEntity = $messagesEntity;
        }
        return $this;
    }
    /**
     * Add item to MessagesEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\MessagesEntity $item
     * @return \ArrayType\ArrayOfMessagesEntity
     */
    public function addToMessagesEntity(\StructType\MessagesEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MessagesEntity) {
            throw new \InvalidArgumentException(sprintf('The MessagesEntity property can only contain items of type \StructType\MessagesEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MessagesEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MessagesEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MessagesEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MessagesEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MessagesEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MessagesEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MessagesEntity
     */
    public function getAttributeName()
    {
        return 'MessagesEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMessagesEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
