<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMerchantBranchListEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfMerchantBranchListEntity extends AbstractStructArrayBase
{
    /**
     * The MerchantBranchListEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MerchantBranchListEntity[]
     */
    public $MerchantBranchListEntity;
    /**
     * Constructor method for ArrayOfMerchantBranchListEntity
     * @uses ArrayOfMerchantBranchListEntity::setMerchantBranchListEntity()
     * @param \StructType\MerchantBranchListEntity[] $merchantBranchListEntity
     */
    public function __construct(array $merchantBranchListEntity = array())
    {
        $this
            ->setMerchantBranchListEntity($merchantBranchListEntity);
    }
    /**
     * Get MerchantBranchListEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MerchantBranchListEntity[]|null
     */
    public function getMerchantBranchListEntity()
    {
        return isset($this->MerchantBranchListEntity) ? $this->MerchantBranchListEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMerchantBranchListEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMerchantBranchListEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMerchantBranchListEntityForArrayConstraintsFromSetMerchantBranchListEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMerchantBranchListEntityMerchantBranchListEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfMerchantBranchListEntityMerchantBranchListEntityItem instanceof \StructType\MerchantBranchListEntity) {
                $invalidValues[] = is_object($arrayOfMerchantBranchListEntityMerchantBranchListEntityItem) ? get_class($arrayOfMerchantBranchListEntityMerchantBranchListEntityItem) : sprintf('%s(%s)', gettype($arrayOfMerchantBranchListEntityMerchantBranchListEntityItem), var_export($arrayOfMerchantBranchListEntityMerchantBranchListEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MerchantBranchListEntity property can only contain items of type \StructType\MerchantBranchListEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MerchantBranchListEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MerchantBranchListEntity[] $merchantBranchListEntity
     * @return \ArrayType\ArrayOfMerchantBranchListEntity
     */
    public function setMerchantBranchListEntity(array $merchantBranchListEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($merchantBranchListEntityArrayErrorMessage = self::validateMerchantBranchListEntityForArrayConstraintsFromSetMerchantBranchListEntity($merchantBranchListEntity))) {
            throw new \InvalidArgumentException($merchantBranchListEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($merchantBranchListEntity) || (is_array($merchantBranchListEntity) && empty($merchantBranchListEntity))) {
            unset($this->MerchantBranchListEntity);
        } else {
            $this->MerchantBranchListEntity = $merchantBranchListEntity;
        }
        return $this;
    }
    /**
     * Add item to MerchantBranchListEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\MerchantBranchListEntity $item
     * @return \ArrayType\ArrayOfMerchantBranchListEntity
     */
    public function addToMerchantBranchListEntity(\StructType\MerchantBranchListEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MerchantBranchListEntity) {
            throw new \InvalidArgumentException(sprintf('The MerchantBranchListEntity property can only contain items of type \StructType\MerchantBranchListEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MerchantBranchListEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MerchantBranchListEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MerchantBranchListEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MerchantBranchListEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MerchantBranchListEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MerchantBranchListEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MerchantBranchListEntity
     */
    public function getAttributeName()
    {
        return 'MerchantBranchListEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMerchantBranchListEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
