<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCountiesEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfCountiesEntity extends AbstractStructArrayBase
{
    /**
     * The CountiesEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CountiesEntity[]
     */
    public $CountiesEntity;
    /**
     * Constructor method for ArrayOfCountiesEntity
     * @uses ArrayOfCountiesEntity::setCountiesEntity()
     * @param \StructType\CountiesEntity[] $countiesEntity
     */
    public function __construct(array $countiesEntity = array())
    {
        $this
            ->setCountiesEntity($countiesEntity);
    }
    /**
     * Get CountiesEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CountiesEntity[]|null
     */
    public function getCountiesEntity()
    {
        return isset($this->CountiesEntity) ? $this->CountiesEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCountiesEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountiesEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountiesEntityForArrayConstraintsFromSetCountiesEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCountiesEntityCountiesEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfCountiesEntityCountiesEntityItem instanceof \StructType\CountiesEntity) {
                $invalidValues[] = is_object($arrayOfCountiesEntityCountiesEntityItem) ? get_class($arrayOfCountiesEntityCountiesEntityItem) : sprintf('%s(%s)', gettype($arrayOfCountiesEntityCountiesEntityItem), var_export($arrayOfCountiesEntityCountiesEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CountiesEntity property can only contain items of type \StructType\CountiesEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CountiesEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CountiesEntity[] $countiesEntity
     * @return \ArrayType\ArrayOfCountiesEntity
     */
    public function setCountiesEntity(array $countiesEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($countiesEntityArrayErrorMessage = self::validateCountiesEntityForArrayConstraintsFromSetCountiesEntity($countiesEntity))) {
            throw new \InvalidArgumentException($countiesEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($countiesEntity) || (is_array($countiesEntity) && empty($countiesEntity))) {
            unset($this->CountiesEntity);
        } else {
            $this->CountiesEntity = $countiesEntity;
        }
        return $this;
    }
    /**
     * Add item to CountiesEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\CountiesEntity $item
     * @return \ArrayType\ArrayOfCountiesEntity
     */
    public function addToCountiesEntity(\StructType\CountiesEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CountiesEntity) {
            throw new \InvalidArgumentException(sprintf('The CountiesEntity property can only contain items of type \StructType\CountiesEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CountiesEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CountiesEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CountiesEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CountiesEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CountiesEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CountiesEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CountiesEntity
     */
    public function getAttributeName()
    {
        return 'CountiesEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCountiesEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
