<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBanksEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfBanksEntity extends AbstractStructArrayBase
{
    /**
     * The BanksEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BanksEntity[]
     */
    public $BanksEntity;
    /**
     * Constructor method for ArrayOfBanksEntity
     * @uses ArrayOfBanksEntity::setBanksEntity()
     * @param \StructType\BanksEntity[] $banksEntity
     */
    public function __construct(array $banksEntity = array())
    {
        $this
            ->setBanksEntity($banksEntity);
    }
    /**
     * Get BanksEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BanksEntity[]|null
     */
    public function getBanksEntity()
    {
        return isset($this->BanksEntity) ? $this->BanksEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBanksEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBanksEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBanksEntityForArrayConstraintsFromSetBanksEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBanksEntityBanksEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfBanksEntityBanksEntityItem instanceof \StructType\BanksEntity) {
                $invalidValues[] = is_object($arrayOfBanksEntityBanksEntityItem) ? get_class($arrayOfBanksEntityBanksEntityItem) : sprintf('%s(%s)', gettype($arrayOfBanksEntityBanksEntityItem), var_export($arrayOfBanksEntityBanksEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BanksEntity property can only contain items of type \StructType\BanksEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BanksEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BanksEntity[] $banksEntity
     * @return \ArrayType\ArrayOfBanksEntity
     */
    public function setBanksEntity(array $banksEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($banksEntityArrayErrorMessage = self::validateBanksEntityForArrayConstraintsFromSetBanksEntity($banksEntity))) {
            throw new \InvalidArgumentException($banksEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($banksEntity) || (is_array($banksEntity) && empty($banksEntity))) {
            unset($this->BanksEntity);
        } else {
            $this->BanksEntity = $banksEntity;
        }
        return $this;
    }
    /**
     * Add item to BanksEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\BanksEntity $item
     * @return \ArrayType\ArrayOfBanksEntity
     */
    public function addToBanksEntity(\StructType\BanksEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BanksEntity) {
            throw new \InvalidArgumentException(sprintf('The BanksEntity property can only contain items of type \StructType\BanksEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BanksEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BanksEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BanksEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BanksEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BanksEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BanksEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BanksEntity
     */
    public function getAttributeName()
    {
        return 'BanksEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBanksEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
