<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBankAccountsEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfBankAccountsEntity extends AbstractStructArrayBase
{
    /**
     * The BankAccountsEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BankAccountsEntity[]
     */
    public $BankAccountsEntity;
    /**
     * Constructor method for ArrayOfBankAccountsEntity
     * @uses ArrayOfBankAccountsEntity::setBankAccountsEntity()
     * @param \StructType\BankAccountsEntity[] $bankAccountsEntity
     */
    public function __construct(array $bankAccountsEntity = array())
    {
        $this
            ->setBankAccountsEntity($bankAccountsEntity);
    }
    /**
     * Get BankAccountsEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BankAccountsEntity[]|null
     */
    public function getBankAccountsEntity()
    {
        return isset($this->BankAccountsEntity) ? $this->BankAccountsEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBankAccountsEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankAccountsEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBankAccountsEntityForArrayConstraintsFromSetBankAccountsEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBankAccountsEntityBankAccountsEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfBankAccountsEntityBankAccountsEntityItem instanceof \StructType\BankAccountsEntity) {
                $invalidValues[] = is_object($arrayOfBankAccountsEntityBankAccountsEntityItem) ? get_class($arrayOfBankAccountsEntityBankAccountsEntityItem) : sprintf('%s(%s)', gettype($arrayOfBankAccountsEntityBankAccountsEntityItem), var_export($arrayOfBankAccountsEntityBankAccountsEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BankAccountsEntity property can only contain items of type \StructType\BankAccountsEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BankAccountsEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankAccountsEntity[] $bankAccountsEntity
     * @return \ArrayType\ArrayOfBankAccountsEntity
     */
    public function setBankAccountsEntity(array $bankAccountsEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($bankAccountsEntityArrayErrorMessage = self::validateBankAccountsEntityForArrayConstraintsFromSetBankAccountsEntity($bankAccountsEntity))) {
            throw new \InvalidArgumentException($bankAccountsEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($bankAccountsEntity) || (is_array($bankAccountsEntity) && empty($bankAccountsEntity))) {
            unset($this->BankAccountsEntity);
        } else {
            $this->BankAccountsEntity = $bankAccountsEntity;
        }
        return $this;
    }
    /**
     * Add item to BankAccountsEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\BankAccountsEntity $item
     * @return \ArrayType\ArrayOfBankAccountsEntity
     */
    public function addToBankAccountsEntity(\StructType\BankAccountsEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BankAccountsEntity) {
            throw new \InvalidArgumentException(sprintf('The BankAccountsEntity property can only contain items of type \StructType\BankAccountsEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BankAccountsEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BankAccountsEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BankAccountsEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BankAccountsEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BankAccountsEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BankAccountsEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BankAccountsEntity
     */
    public function getAttributeName()
    {
        return 'BankAccountsEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBankAccountsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
