<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountCreditCardsEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfAccountCreditCardsEntity extends AbstractStructArrayBase
{
    /**
     * The AccountCreditCardsEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountCreditCardsEntity[]
     */
    public $AccountCreditCardsEntity;
    /**
     * Constructor method for ArrayOfAccountCreditCardsEntity
     * @uses ArrayOfAccountCreditCardsEntity::setAccountCreditCardsEntity()
     * @param \StructType\AccountCreditCardsEntity[] $accountCreditCardsEntity
     */
    public function __construct(array $accountCreditCardsEntity = array())
    {
        $this
            ->setAccountCreditCardsEntity($accountCreditCardsEntity);
    }
    /**
     * Get AccountCreditCardsEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountCreditCardsEntity[]|null
     */
    public function getAccountCreditCardsEntity()
    {
        return isset($this->AccountCreditCardsEntity) ? $this->AccountCreditCardsEntity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountCreditCardsEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountCreditCardsEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountCreditCardsEntityForArrayConstraintsFromSetAccountCreditCardsEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAccountCreditCardsEntityAccountCreditCardsEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountCreditCardsEntityAccountCreditCardsEntityItem instanceof \StructType\AccountCreditCardsEntity) {
                $invalidValues[] = is_object($arrayOfAccountCreditCardsEntityAccountCreditCardsEntityItem) ? get_class($arrayOfAccountCreditCardsEntityAccountCreditCardsEntityItem) : sprintf('%s(%s)', gettype($arrayOfAccountCreditCardsEntityAccountCreditCardsEntityItem), var_export($arrayOfAccountCreditCardsEntityAccountCreditCardsEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountCreditCardsEntity property can only contain items of type \StructType\AccountCreditCardsEntity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountCreditCardsEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountCreditCardsEntity[] $accountCreditCardsEntity
     * @return \ArrayType\ArrayOfAccountCreditCardsEntity
     */
    public function setAccountCreditCardsEntity(array $accountCreditCardsEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($accountCreditCardsEntityArrayErrorMessage = self::validateAccountCreditCardsEntityForArrayConstraintsFromSetAccountCreditCardsEntity($accountCreditCardsEntity))) {
            throw new \InvalidArgumentException($accountCreditCardsEntityArrayErrorMessage, __LINE__);
        }
        if (is_null($accountCreditCardsEntity) || (is_array($accountCreditCardsEntity) && empty($accountCreditCardsEntity))) {
            unset($this->AccountCreditCardsEntity);
        } else {
            $this->AccountCreditCardsEntity = $accountCreditCardsEntity;
        }
        return $this;
    }
    /**
     * Add item to AccountCreditCardsEntity value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountCreditCardsEntity $item
     * @return \ArrayType\ArrayOfAccountCreditCardsEntity
     */
    public function addToAccountCreditCardsEntity(\StructType\AccountCreditCardsEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountCreditCardsEntity) {
            throw new \InvalidArgumentException(sprintf('The AccountCreditCardsEntity property can only contain items of type \StructType\AccountCreditCardsEntity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccountCreditCardsEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccountCreditCardsEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccountCreditCardsEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccountCreditCardsEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccountCreditCardsEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccountCreditCardsEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountCreditCardsEntity
     */
    public function getAttributeName()
    {
        return 'AccountCreditCardsEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAccountCreditCardsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
