<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for With ServiceType
 */
$with = new \ServiceType\With($options);
$with->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for WithDrawalRequestCancel operation/method
 */
if ($with->WithDrawalRequestCancel(new \StructType\WithDrawalRequestCancel()) !== false) {
    print_r($with->getResult());
} else {
    print_r($with->getLastError());
}
/**
 * Sample call for WithDrawalBankTransferControl operation/method
 */
if ($with->WithDrawalBankTransferControl(new \StructType\WithDrawalBankTransferControl()) !== false) {
    print_r($with->getResult());
} else {
    print_r($with->getLastError());
}
/**
 * Sample call for WithDrawalBankTransfer operation/method
 */
if ($with->WithDrawalBankTransfer(new \StructType\WithDrawalBankTransfer()) !== false) {
    print_r($with->getResult());
} else {
    print_r($with->getLastError());
}
/**
 * Sample call for WithDrawalBranchTransferControl operation/method
 */
if ($with->WithDrawalBranchTransferControl(new \StructType\WithDrawalBranchTransferControl()) !== false) {
    print_r($with->getResult());
} else {
    print_r($with->getLastError());
}
/**
 * Sample call for WithDrawalBranchTransfer operation/method
 */
if ($with->WithDrawalBranchTransfer(new \StructType\WithDrawalBranchTransfer()) !== false) {
    print_r($with->getResult());
} else {
    print_r($with->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for GetLoadMoneyRequestDetail operation/method
 */
if ($get->GetLoadMoneyRequestDetail(new \StructType\GetLoadMoneyRequestDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMoneyRequest operation/method
 */
if ($get->GetMoneyRequest(new \StructType\GetMoneyRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyMoneyRequest operation/method
 */
if ($get->GetMyMoneyRequest(new \StructType\GetMyMoneyRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMoneyRequestDetail operation/method
 */
if ($get->GetMoneyRequestDetail(new \StructType\GetMoneyRequestDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuickTransactionList operation/method
 */
if ($get->GetQuickTransactionList(new \StructType\GetQuickTransactionList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuickTransactionDetail operation/method
 */
if ($get->GetQuickTransactionDetail(new \StructType\GetQuickTransactionDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountCreditCardList operation/method
 */
if ($get->GetAccountCreditCardList(new \StructType\GetAccountCreditCardList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContract operation/method
 */
if ($get->GetContract(new \StructType\GetContract()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOnboarding operation/method
 */
if ($get->GetOnboarding(new \StructType\GetOnboarding()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOnboard operation/method
 */
if ($get->GetOnboard(new \StructType\GetOnboard()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSecurityQuestion operation/method
 */
if ($get->GetSecurityQuestion(new \StructType\GetSecurityQuestion()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWalletType operation/method
 */
if ($get->GetWalletType(new \StructType\GetWalletType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDashBoard operation/method
 */
if ($get->GetDashBoard(new \StructType\GetDashBoard()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountDetail operation/method
 */
if ($get->GetAccountDetail(new \StructType\GetAccountDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLastErrorLogin operation/method
 */
if ($get->GetLastErrorLogin(new \StructType\GetLastErrorLogin()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLastTransaction operation/method
 */
if ($get->GetLastTransaction(new \StructType\GetLastTransaction()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLastTransactionAmount operation/method
 */
if ($get->GetLastTransactionAmount(new \StructType\GetLastTransactionAmount()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountBalance operation/method
 */
if ($get->GetAccountBalance(new \StructType\GetAccountBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPersonelAdress operation/method
 */
if ($get->GetPersonelAdress(new \StructType\GetPersonelAdress()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPersonelIdentity operation/method
 */
if ($get->GetPersonelIdentity(new \StructType\GetPersonelIdentity()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountWallets operation/method
 */
if ($get->GetAccountWallets(new \StructType\GetAccountWallets()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountWalletCount operation/method
 */
if ($get->GetAccountWalletCount(new \StructType\GetAccountWalletCount()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWalletDetail operation/method
 */
if ($get->GetWalletDetail(new \StructType\GetWalletDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWalletShoppingTypeAmount operation/method
 */
if ($get->GetWalletShoppingTypeAmount(new \StructType\GetWalletShoppingTypeAmount()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWalletTransactionList operation/method
 */
if ($get->GetWalletTransactionList(new \StructType\GetWalletTransactionList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWalletLastTransactionList operation/method
 */
if ($get->GetWalletLastTransactionList(new \StructType\GetWalletLastTransactionList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransactionList operation/method
 */
if ($get->GetTransactionList(new \StructType\GetTransactionList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransactionDetail operation/method
 */
if ($get->GetTransactionDetail(new \StructType\GetTransactionDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBankList operation/method
 */
if ($get->GetBankList(new \StructType\GetBankList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLoadMoneyBankList operation/method
 */
if ($get->GetLoadMoneyBankList(new \StructType\GetLoadMoneyBankList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetATMList operation/method
 */
if ($get->GetATMList(new \StructType\GetATMList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBankDetail operation/method
 */
if ($get->GetBankDetail(new \StructType\GetBankDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountBankList operation/method
 */
if ($get->GetAccountBankList(new \StructType\GetAccountBankList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubBranchList operation/method
 */
if ($get->GetSubBranchList(new \StructType\GetSubBranchList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBranchListwithLocation operation/method
 */
if ($get->GetBranchListwithLocation(new \StructType\GetBranchListwithLocation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBranchListwithLoadMoney operation/method
 */
if ($get->GetBranchListwithLoadMoney(new \StructType\GetBranchListwithLoadMoney()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBranchListwithCoordinate operation/method
 */
if ($get->GetBranchListwithCoordinate(new \StructType\GetBranchListwithCoordinate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLoacation operation/method
 */
if ($get->GetLoacation(new \StructType\GetLoacation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCountryList operation/method
 */
if ($get->GetCountryList(new \StructType\GetCountryList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCityList operation/method
 */
if ($get->GetCityList(new \StructType\GetCityList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCountyList operation/method
 */
if ($get->GetCountyList(new \StructType\GetCountyList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMessageList operation/method
 */
if ($get->GetMessageList(new \StructType\GetMessageList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFirstMessageDate operation/method
 */
if ($get->GetFirstMessageDate(new \StructType\GetFirstMessageDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMessageDetailList operation/method
 */
if ($get->GetMessageDetailList(new \StructType\GetMessageDetailList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLoadMoneyRequest operation/method
 */
if ($get->GetLoadMoneyRequest(new \StructType\GetLoadMoneyRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLoadMoneyBranchRequest operation/method
 */
if ($get->GetLoadMoneyBranchRequest(new \StructType\GetLoadMoneyBranchRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWithDrawalRequest operation/method
 */
if ($get->GetWithDrawalRequest(new \StructType\GetWithDrawalRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Money ServiceType
 */
$money = new \ServiceType\Money($options);
$money->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for MoneyRequestCancel operation/method
 */
if ($money->MoneyRequestCancel(new \StructType\MoneyRequestCancel()) !== false) {
    print_r($money->getResult());
} else {
    print_r($money->getLastError());
}
/**
 * Sample call for MoneyRequestConfirm operation/method
 */
if ($money->MoneyRequestConfirm(new \StructType\MoneyRequestConfirm()) !== false) {
    print_r($money->getResult());
} else {
    print_r($money->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for AddQuickTransaction operation/method
 */
if ($add->AddQuickTransaction(new \StructType\AddQuickTransaction()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for DeleteAccountCreditCart operation/method
 */
if ($delete->DeleteAccountCreditCart(new \StructType\DeleteAccountCreditCart()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteWallet operation/method
 */
if ($delete->DeleteWallet(new \StructType\DeleteWallet()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteAccountBank operation/method
 */
if ($delete->DeleteAccountBank(new \StructType\DeleteAccountBank()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteMessage operation/method
 */
if ($delete->DeleteMessage(new \StructType\DeleteMessage()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Shopping ServiceType
 */
$shopping = new \ServiceType\Shopping($options);
$shopping->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for ShoppingQrCodeConvert operation/method
 */
if ($shopping->ShoppingQrCodeConvert(new \StructType\ShoppingQrCodeConvert()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingAddtoCartforQrCode operation/method
 */
if ($shopping->ShoppingAddtoCartforQrCode(new \StructType\ShoppingAddtoCartforQrCode()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingAddtoCart operation/method
 */
if ($shopping->ShoppingAddtoCart(new \StructType\ShoppingAddtoCart()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingGetCart operation/method
 */
if ($shopping->ShoppingGetCart(new \StructType\ShoppingGetCart()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingDeleteProducttoCart operation/method
 */
if ($shopping->ShoppingDeleteProducttoCart(new \StructType\ShoppingDeleteProducttoCart()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingCartAmount operation/method
 */
if ($shopping->ShoppingCartAmount(new \StructType\ShoppingCartAmount()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingAddNewAdress operation/method
 */
if ($shopping->ShoppingAddNewAdress(new \StructType\ShoppingAddNewAdress()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingGetAdressList operation/method
 */
if ($shopping->ShoppingGetAdressList(new \StructType\ShoppingGetAdressList()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingGetAllAdressList operation/method
 */
if ($shopping->ShoppingGetAllAdressList(new \StructType\ShoppingGetAllAdressList()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingGetAdressDetail operation/method
 */
if ($shopping->ShoppingGetAdressDetail(new \StructType\ShoppingGetAdressDetail()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingAdressUpdate operation/method
 */
if ($shopping->ShoppingAdressUpdate(new \StructType\ShoppingAdressUpdate()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingAdressDelete operation/method
 */
if ($shopping->ShoppingAdressDelete(new \StructType\ShoppingAdressDelete()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingPaywithWalletCodeforCart operation/method
 */
if ($shopping->ShoppingPaywithWalletCodeforCart(new \StructType\ShoppingPaywithWalletCodeforCart()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingPaywithWalletCodeforAddition operation/method
 */
if ($shopping->ShoppingPaywithWalletCodeforAddition(new \StructType\ShoppingPaywithWalletCodeforAddition()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingPaywithWalletCodeforJson operation/method
 */
if ($shopping->ShoppingPaywithWalletCodeforJson(new \StructType\ShoppingPaywithWalletCodeforJson()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingPaywithCreditCartCodeforCart operation/method
 */
if ($shopping->ShoppingPaywithCreditCartCodeforCart(new \StructType\ShoppingPaywithCreditCartCodeforCart()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingPaywithCreditCartCodeforAddition operation/method
 */
if ($shopping->ShoppingPaywithCreditCartCodeforAddition(new \StructType\ShoppingPaywithCreditCartCodeforAddition()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Sample call for ShoppingPaywithCreditCartCodeforJson operation/method
 */
if ($shopping->ShoppingPaywithCreditCartCodeforJson(new \StructType\ShoppingPaywithCreditCartCodeforJson()) !== false) {
    print_r($shopping->getResult());
} else {
    print_r($shopping->getLastError());
}
/**
 * Samples for Pay ServiceType
 */
$pay = new \ServiceType\Pay($options);
$pay->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for PayPointGetResellerInstitons operation/method
 */
if ($pay->PayPointGetResellerInstitons(new \StructType\PayPointGetResellerInstitons()) !== false) {
    print_r($pay->getResult());
} else {
    print_r($pay->getLastError());
}
/**
 * Sample call for PayPointBillInquiry operation/method
 */
if ($pay->PayPointBillInquiry(new \StructType\PayPointBillInquiry()) !== false) {
    print_r($pay->getResult());
} else {
    print_r($pay->getLastError());
}
/**
 * Samples for Bill ServiceType
 */
$bill = new \ServiceType\Bill($options);
$bill->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for BillPayment operation/method
 */
if ($bill->BillPayment(new \StructType\BillPayment()) !== false) {
    print_r($bill->getResult());
} else {
    print_r($bill->getLastError());
}
/**
 * Samples for Game ServiceType
 */
$game = new \ServiceType\Game($options);
$game->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for GameSultanGetMember operation/method
 */
if ($game->GameSultanGetMember(new \StructType\GameSultanGetMember()) !== false) {
    print_r($game->getResult());
} else {
    print_r($game->getLastError());
}
/**
 * Samples for Log ServiceType
 */
$log = new \ServiceType\Log($options);
$log->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for LogOut operation/method
 */
if ($log->LogOut(new \StructType\LogOut()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Sample call for LogOnWithAccountCode operation/method
 */
if ($log->LogOnWithAccountCode(new \StructType\LogOnWithAccountCode()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Sample call for LogOnWithPhoneNumber operation/method
 */
if ($log->LogOnWithPhoneNumber(new \StructType\LogOnWithPhoneNumber()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Sample call for LogOnWithPin operation/method
 */
if ($log->LogOnWithPin(new \StructType\LogOnWithPin()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Sample call for LogOnWithMail operation/method
 */
if ($log->LogOnWithMail(new \StructType\LogOnWithMail()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Samples for Decyrpt ServiceType
 */
$decyrpt = new \ServiceType\Decyrpt($options);
/**
 * Sample call for DecyrptData operation/method
 */
if ($decyrpt->DecyrptData(new \StructType\DecyrptData()) !== false) {
    print_r($decyrpt->getResult());
} else {
    print_r($decyrpt->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \ServiceType\Test($options);
/**
 * Sample call for TestMethodx operation/method
 */
if ($test->TestMethodx(new \StructType\TestMethodx()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for CreateAccountControl operation/method
 */
if ($create->CreateAccountControl(new \StructType\CreateAccountControl()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAccountInformationControl operation/method
 */
if ($create->CreateAccountInformationControl(new \StructType\CreateAccountInformationControl()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAccountPasswordControl operation/method
 */
if ($create->CreateAccountPasswordControl(new \StructType\CreateAccountPasswordControl()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAccount operation/method
 */
if ($create->CreateAccount(new \StructType\CreateAccount()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateMobilePin operation/method
 */
if ($create->CreateMobilePin(new \StructType\CreateMobilePin()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateMobilePinPass operation/method
 */
if ($create->CreateMobilePinPass(new \StructType\CreateMobilePinPass()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateWalletControl operation/method
 */
if ($create->CreateWalletControl(new \StructType\CreateWalletControl()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateWallet operation/method
 */
if ($create->CreateWallet(new \StructType\CreateWallet()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateNewBankAccount operation/method
 */
if ($create->CreateNewBankAccount(new \StructType\CreateNewBankAccount()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
$send->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for SendSmsforCreateAccount operation/method
 */
if ($send->SendSmsforCreateAccount(new \StructType\SendSmsforCreateAccount()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMailAgainforCreateAccount operation/method
 */
if ($send->SendMailAgainforCreateAccount(new \StructType\SendMailAgainforCreateAccount()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendSmsAgainforCreateAccount operation/method
 */
if ($send->SendSmsAgainforCreateAccount(new \StructType\SendSmsAgainforCreateAccount()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendSmsAgainforLogin operation/method
 */
if ($send->SendSmsAgainforLogin(new \StructType\SendSmsAgainforLogin()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendPdf operation/method
 */
if ($send->SendPdf(new \StructType\SendPdf()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMessage operation/method
 */
if ($send->SendMessage(new \StructType\SendMessage()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMessageAnswer operation/method
 */
if ($send->SendMessageAnswer(new \StructType\SendMessageAnswer()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMoneyControl operation/method
 */
if ($send->SendMoneyControl(new \StructType\SendMoneyControl()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMoney operation/method
 */
if ($send->SendMoney(new \StructType\SendMoney()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMoneyControlforSdk operation/method
 */
if ($send->SendMoneyControlforSdk(new \StructType\SendMoneyControlforSdk()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendMoneyforSdk operation/method
 */
if ($send->SendMoneyforSdk(new \StructType\SendMoneyforSdk()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
$validate->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for ValidateMobileActivation operation/method
 */
if ($validate->ValidateMobileActivation(new \StructType\ValidateMobileActivation()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateMailActivation operation/method
 */
if ($validate->ValidateMailActivation(new \StructType\ValidateMailActivation()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateSmsActivation operation/method
 */
if ($validate->ValidateSmsActivation(new \StructType\ValidateSmsActivation()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateSms operation/method
 */
if ($validate->ValidateSms(new \StructType\ValidateSms()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Re ServiceType
 */
$re = new \ServiceType\Re($options);
$re->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for ReSendSmsforCreateAccount operation/method
 */
if ($re->ReSendSmsforCreateAccount(new \StructType\ReSendSmsforCreateAccount()) !== false) {
    print_r($re->getResult());
} else {
    print_r($re->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
$check->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for CheckDeviceVersionControl operation/method
 */
if ($check->CheckDeviceVersionControl(new \StructType\CheckDeviceVersionControl()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckDeviceKeyIsDefined operation/method
 */
if ($check->CheckDeviceKeyIsDefined(new \StructType\CheckDeviceKeyIsDefined()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckDeviceKeyIsPinActived operation/method
 */
if ($check->CheckDeviceKeyIsPinActived(new \StructType\CheckDeviceKeyIsPinActived()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckDeviceKeyIsPinCreated operation/method
 */
if ($check->CheckDeviceKeyIsPinCreated(new \StructType\CheckDeviceKeyIsPinCreated()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Forget ServiceType
 */
$forget = new \ServiceType\Forget($options);
$forget->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for ForgetPasswordwithdMailandMobile operation/method
 */
if ($forget->ForgetPasswordwithdMailandMobile(new \StructType\ForgetPasswordwithdMailandMobile()) !== false) {
    print_r($forget->getResult());
} else {
    print_r($forget->getLastError());
}
/**
 * Sample call for ForgetPassWithdMailandMobile operation/method
 */
if ($forget->ForgetPassWithdMailandMobile(new \StructType\ForgetPassWithdMailandMobile()) !== false) {
    print_r($forget->getResult());
} else {
    print_r($forget->getLastError());
}
/**
 * Sample call for ForgetPasswordwithdMailandMobileControl operation/method
 */
if ($forget->ForgetPasswordwithdMailandMobileControl(new \StructType\ForgetPasswordwithdMailandMobileControl()) !== false) {
    print_r($forget->getResult());
} else {
    print_r($forget->getLastError());
}
/**
 * Sample call for ForgetPasswordwithdMailandMobileValidateCode operation/method
 */
if ($forget->ForgetPasswordwithdMailandMobileValidateCode(new \StructType\ForgetPasswordwithdMailandMobileValidateCode()) !== false) {
    print_r($forget->getResult());
} else {
    print_r($forget->getLastError());
}
/**
 * Sample call for ForgetPasswordwithMailandMobilePassword operation/method
 */
if ($forget->ForgetPasswordwithMailandMobilePassword(new \StructType\ForgetPasswordwithMailandMobilePassword()) !== false) {
    print_r($forget->getResult());
} else {
    print_r($forget->getLastError());
}
/**
 * Sample call for ForgetPasswordMailandMobileReSendSms operation/method
 */
if ($forget->ForgetPasswordMailandMobileReSendSms(new \StructType\ForgetPasswordMailandMobileReSendSms()) !== false) {
    print_r($forget->getResult());
} else {
    print_r($forget->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \ServiceType\Reset($options);
$reset->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for ResetAccountPassword operation/method
 */
if ($reset->ResetAccountPassword(new \StructType\ResetAccountPassword()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
$is->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for IsAccountVerification operation/method
 */
if ($is->IsAccountVerification(new \StructType\IsAccountVerification()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for IsAccountPassCorrect operation/method
 */
if ($is->IsAccountPassCorrect(new \StructType\IsAccountPassCorrect()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for UpdateWalletDefault operation/method
 */
if ($update->UpdateWalletDefault(new \StructType\UpdateWalletDefault()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateWalletDescription operation/method
 */
if ($update->UpdateWalletDescription(new \StructType\UpdateWalletDescription()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateMobilePin operation/method
 */
if ($update->UpdateMobilePin(new \StructType\UpdateMobilePin()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAccountIdentity operation/method
 */
if ($update->UpdateAccountIdentity(new \StructType\UpdateAccountIdentity()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAccountPersonelIdentityInformation operation/method
 */
if ($update->UpdateAccountPersonelIdentityInformation(new \StructType\UpdateAccountPersonelIdentityInformation()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAccountPersonelAdresInformation operation/method
 */
if ($update->UpdateAccountPersonelAdresInformation(new \StructType\UpdateAccountPersonelAdresInformation()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
$set->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for SetWalletOrder operation/method
 */
if ($set->SetWalletOrder(new \StructType\SetWalletOrder()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Collet ServiceType
 */
$collet = new \ServiceType\Collet($options);
$collet->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for ColletBalanceofWallet operation/method
 */
if ($collet->ColletBalanceofWallet(new \StructType\ColletBalanceofWallet()) !== false) {
    print_r($collet->getResult());
} else {
    print_r($collet->getLastError());
}
/**
 * Samples for Share ServiceType
 */
$share = new \ServiceType\Share($options);
$share->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for ShareAccountCodeforMail operation/method
 */
if ($share->ShareAccountCodeforMail(new \StructType\ShareAccountCodeforMail()) !== false) {
    print_r($share->getResult());
} else {
    print_r($share->getLastError());
}
/**
 * Sample call for ShareWalletCodforMail operation/method
 */
if ($share->ShareWalletCodforMail(new \StructType\ShareWalletCodforMail()) !== false) {
    print_r($share->getResult());
} else {
    print_r($share->getLastError());
}
/**
 * Sample call for ShareAccountCodforPhone operation/method
 */
if ($share->ShareAccountCodforPhone(new \StructType\ShareAccountCodforPhone()) !== false) {
    print_r($share->getResult());
} else {
    print_r($share->getLastError());
}
/**
 * Sample call for ShareWalletCodforPhone operation/method
 */
if ($share->ShareWalletCodforPhone(new \StructType\ShareWalletCodforPhone()) !== false) {
    print_r($share->getResult());
} else {
    print_r($share->getLastError());
}
/**
 * Samples for Replace ServiceType
 */
$replace = new \ServiceType\Replace($options);
$replace->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for ReplacePassword operation/method
 */
if ($replace->ReplacePassword(new \StructType\ReplacePassword()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Sample call for ReplaceMail operation/method
 */
if ($replace->ReplaceMail(new \StructType\ReplaceMail()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Sample call for ReplaceMailValidateOldMail operation/method
 */
if ($replace->ReplaceMailValidateOldMail(new \StructType\ReplaceMailValidateOldMail()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Sample call for ReplaceMailValidateNewMail operation/method
 */
if ($replace->ReplaceMailValidateNewMail(new \StructType\ReplaceMailValidateNewMail()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Sample call for ReplacePhone operation/method
 */
if ($replace->ReplacePhone(new \StructType\ReplacePhone()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Sample call for ReplacePhoneValidateOldPhone operation/method
 */
if ($replace->ReplacePhoneValidateOldPhone(new \StructType\ReplacePhoneValidateOldPhone()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Sample call for ReplacePhoneValidateNewPhone operation/method
 */
if ($replace->ReplacePhoneValidateNewPhone(new \StructType\ReplacePhoneValidateNewPhone()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Samples for Mobile ServiceType
 */
$mobile = new \ServiceType\Mobile($options);
$mobile->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for MobileDevicePinRemove operation/method
 */
if ($mobile->MobileDevicePinRemove(new \StructType\MobileDevicePinRemove()) !== false) {
    print_r($mobile->getResult());
} else {
    print_r($mobile->getLastError());
}
/**
 * Samples for Branch ServiceType
 */
$branch = new \ServiceType\Branch($options);
$branch->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for BranchListExist operation/method
 */
if ($branch->BranchListExist(new \StructType\BranchListExist()) !== false) {
    print_r($branch->getResult());
} else {
    print_r($branch->getLastError());
}
/**
 * Samples for Identity ServiceType
 */
$identity = new \ServiceType\Identity($options);
$identity->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for IdentityControl operation/method
 */
if ($identity->IdentityControl(new \StructType\IdentityControl()) !== false) {
    print_r($identity->getResult());
} else {
    print_r($identity->getLastError());
}
/**
 * Samples for Account ServiceType
 */
$account = new \ServiceType\Account($options);
$account->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for AccountVerification operation/method
 */
if ($account->AccountVerification(new \StructType\AccountVerification()) !== false) {
    print_r($account->getResult());
} else {
    print_r($account->getLastError());
}
/**
 * Sample call for AccountIdentityControl operation/method
 */
if ($account->AccountIdentityControl(new \StructType\AccountIdentityControl()) !== false) {
    print_r($account->getResult());
} else {
    print_r($account->getLastError());
}
/**
 * Sample call for AccountApprove operation/method
 */
if ($account->AccountApprove(new \StructType\AccountApprove()) !== false) {
    print_r($account->getResult());
} else {
    print_r($account->getLastError());
}
/**
 * Sample call for AccountPersonelIdentityControl operation/method
 */
if ($account->AccountPersonelIdentityControl(new \StructType\AccountPersonelIdentityControl()) !== false) {
    print_r($account->getResult());
} else {
    print_r($account->getLastError());
}
/**
 * Samples for Boost ServiceType
 */
$boost = new \ServiceType\Boost($options);
$boost->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for BoostLimit operation/method
 */
if ($boost->BoostLimit(new \StructType\BoostLimit()) !== false) {
    print_r($boost->getResult());
} else {
    print_r($boost->getLastError());
}
/**
 * Samples for Load ServiceType
 */
$load = new \ServiceType\Load($options);
$load->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for LoadMoneywithBankTransferControl operation/method
 */
if ($load->LoadMoneywithBankTransferControl(new \StructType\LoadMoneywithBankTransferControl()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadMoneywithBankTransfer operation/method
 */
if ($load->LoadMoneywithBankTransfer(new \StructType\LoadMoneywithBankTransfer()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadMoneywithATMTransferControl operation/method
 */
if ($load->LoadMoneywithATMTransferControl(new \StructType\LoadMoneywithATMTransferControl()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadMoneywithATMTransfer operation/method
 */
if ($load->LoadMoneywithATMTransfer(new \StructType\LoadMoneywithATMTransfer()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadMoneywithBranchTransferControl operation/method
 */
if ($load->LoadMoneywithBranchTransferControl(new \StructType\LoadMoneywithBranchTransferControl()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadMoneywithBranchTransfer operation/method
 */
if ($load->LoadMoneywithBranchTransfer(new \StructType\LoadMoneywithBranchTransfer()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadMoneyRequestCancel operation/method
 */
if ($load->LoadMoneyRequestCancel(new \StructType\LoadMoneyRequestCancel()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Samples for Wallet ServiceType
 */
$wallet = new \ServiceType\Wallet($options);
$wallet->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for WalletTransfer operation/method
 */
if ($wallet->WalletTransfer(new \StructType\WalletTransfer()) !== false) {
    print_r($wallet->getResult());
} else {
    print_r($wallet->getLastError());
}
/**
 * Samples for Want ServiceType
 */
$want = new \ServiceType\Want($options);
$want->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for WantDebt operation/method
 */
if ($want->WantDebt(new \StructType\WantDebt()) !== false) {
    print_r($want->getResult());
} else {
    print_r($want->getLastError());
}
