<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WalletsEntity StructType
 * @subpackage Structs
 */
class WalletsEntity extends WalletEntityUI
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountId;
    /**
     * The WalletCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletCode;
    /**
     * The WalletTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletTypeId;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastTransactionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastTransactionDate;
    /**
     * The IsActived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActived;
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsServiceWallet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsServiceWallet;
    /**
     * The IsCommissionWallet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCommissionWallet;
    /**
     * The WalletServiceTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletServiceTypeId;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDefault;
    /**
     * The WalletOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletOrder;
    /**
     * The WalletLongName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletLongName;
    /**
     * The ServiceTypetName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceTypetName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The WalletType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WalletTypesEntity
     */
    public $WalletType;
    /**
     * The CurrencyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyType;
    /**
     * Constructor method for WalletsEntity
     * @uses WalletsEntity::setId()
     * @uses WalletsEntity::setAccountId()
     * @uses WalletsEntity::setWalletCode()
     * @uses WalletsEntity::setWalletTypeId()
     * @uses WalletsEntity::setCreateDate()
     * @uses WalletsEntity::setLastTransactionDate()
     * @uses WalletsEntity::setIsActived()
     * @uses WalletsEntity::setIsDeleted()
     * @uses WalletsEntity::setIsServiceWallet()
     * @uses WalletsEntity::setIsCommissionWallet()
     * @uses WalletsEntity::setWalletServiceTypeId()
     * @uses WalletsEntity::setIsDefault()
     * @uses WalletsEntity::setWalletOrder()
     * @uses WalletsEntity::setWalletLongName()
     * @uses WalletsEntity::setServiceTypetName()
     * @uses WalletsEntity::setDescription()
     * @uses WalletsEntity::setWalletType()
     * @uses WalletsEntity::setCurrencyType()
     * @param int $id
     * @param int $accountId
     * @param int $walletCode
     * @param int $walletTypeId
     * @param string $createDate
     * @param string $lastTransactionDate
     * @param bool $isActived
     * @param bool $isDeleted
     * @param bool $isServiceWallet
     * @param bool $isCommissionWallet
     * @param int $walletServiceTypeId
     * @param bool $isDefault
     * @param int $walletOrder
     * @param string $walletLongName
     * @param string $serviceTypetName
     * @param string $description
     * @param \StructType\WalletTypesEntity $walletType
     * @param string $currencyType
     */
    public function __construct($id = null, $accountId = null, $walletCode = null, $walletTypeId = null, $createDate = null, $lastTransactionDate = null, $isActived = null, $isDeleted = null, $isServiceWallet = null, $isCommissionWallet = null, $walletServiceTypeId = null, $isDefault = null, $walletOrder = null, $walletLongName = null, $serviceTypetName = null, $description = null, \StructType\WalletTypesEntity $walletType = null, $currencyType = null)
    {
        $this
            ->setId($id)
            ->setAccountId($accountId)
            ->setWalletCode($walletCode)
            ->setWalletTypeId($walletTypeId)
            ->setCreateDate($createDate)
            ->setLastTransactionDate($lastTransactionDate)
            ->setIsActived($isActived)
            ->setIsDeleted($isDeleted)
            ->setIsServiceWallet($isServiceWallet)
            ->setIsCommissionWallet($isCommissionWallet)
            ->setWalletServiceTypeId($walletServiceTypeId)
            ->setIsDefault($isDefault)
            ->setWalletOrder($walletOrder)
            ->setWalletLongName($walletLongName)
            ->setServiceTypetName($serviceTypetName)
            ->setDescription($description)
            ->setWalletType($walletType)
            ->setCurrencyType($currencyType);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\WalletsEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get AccountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\WalletsEntity
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get WalletCode value
     * @return int
     */
    public function getWalletCode()
    {
        return $this->WalletCode;
    }
    /**
     * Set WalletCode value
     * @param int $walletCode
     * @return \StructType\WalletsEntity
     */
    public function setWalletCode($walletCode = null)
    {
        // validation for constraint: int
        if (!is_null($walletCode) && !(is_int($walletCode) || ctype_digit($walletCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletCode, true), gettype($walletCode)), __LINE__);
        }
        $this->WalletCode = $walletCode;
        return $this;
    }
    /**
     * Get WalletTypeId value
     * @return int
     */
    public function getWalletTypeId()
    {
        return $this->WalletTypeId;
    }
    /**
     * Set WalletTypeId value
     * @param int $walletTypeId
     * @return \StructType\WalletsEntity
     */
    public function setWalletTypeId($walletTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($walletTypeId) && !(is_int($walletTypeId) || ctype_digit($walletTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletTypeId, true), gettype($walletTypeId)), __LINE__);
        }
        $this->WalletTypeId = $walletTypeId;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\WalletsEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastTransactionDate value
     * @return string
     */
    public function getLastTransactionDate()
    {
        return $this->LastTransactionDate;
    }
    /**
     * Set LastTransactionDate value
     * @param string $lastTransactionDate
     * @return \StructType\WalletsEntity
     */
    public function setLastTransactionDate($lastTransactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastTransactionDate) && !is_string($lastTransactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTransactionDate, true), gettype($lastTransactionDate)), __LINE__);
        }
        $this->LastTransactionDate = $lastTransactionDate;
        return $this;
    }
    /**
     * Get IsActived value
     * @return bool
     */
    public function getIsActived()
    {
        return $this->IsActived;
    }
    /**
     * Set IsActived value
     * @param bool $isActived
     * @return \StructType\WalletsEntity
     */
    public function setIsActived($isActived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActived) && !is_bool($isActived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActived, true), gettype($isActived)), __LINE__);
        }
        $this->IsActived = $isActived;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\WalletsEntity
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get IsServiceWallet value
     * @return bool
     */
    public function getIsServiceWallet()
    {
        return $this->IsServiceWallet;
    }
    /**
     * Set IsServiceWallet value
     * @param bool $isServiceWallet
     * @return \StructType\WalletsEntity
     */
    public function setIsServiceWallet($isServiceWallet = null)
    {
        // validation for constraint: boolean
        if (!is_null($isServiceWallet) && !is_bool($isServiceWallet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isServiceWallet, true), gettype($isServiceWallet)), __LINE__);
        }
        $this->IsServiceWallet = $isServiceWallet;
        return $this;
    }
    /**
     * Get IsCommissionWallet value
     * @return bool
     */
    public function getIsCommissionWallet()
    {
        return $this->IsCommissionWallet;
    }
    /**
     * Set IsCommissionWallet value
     * @param bool $isCommissionWallet
     * @return \StructType\WalletsEntity
     */
    public function setIsCommissionWallet($isCommissionWallet = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommissionWallet) && !is_bool($isCommissionWallet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommissionWallet, true), gettype($isCommissionWallet)), __LINE__);
        }
        $this->IsCommissionWallet = $isCommissionWallet;
        return $this;
    }
    /**
     * Get WalletServiceTypeId value
     * @return int
     */
    public function getWalletServiceTypeId()
    {
        return $this->WalletServiceTypeId;
    }
    /**
     * Set WalletServiceTypeId value
     * @param int $walletServiceTypeId
     * @return \StructType\WalletsEntity
     */
    public function setWalletServiceTypeId($walletServiceTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($walletServiceTypeId) && !(is_int($walletServiceTypeId) || ctype_digit($walletServiceTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletServiceTypeId, true), gettype($walletServiceTypeId)), __LINE__);
        }
        $this->WalletServiceTypeId = $walletServiceTypeId;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \StructType\WalletsEntity
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get WalletOrder value
     * @return int
     */
    public function getWalletOrder()
    {
        return $this->WalletOrder;
    }
    /**
     * Set WalletOrder value
     * @param int $walletOrder
     * @return \StructType\WalletsEntity
     */
    public function setWalletOrder($walletOrder = null)
    {
        // validation for constraint: int
        if (!is_null($walletOrder) && !(is_int($walletOrder) || ctype_digit($walletOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletOrder, true), gettype($walletOrder)), __LINE__);
        }
        $this->WalletOrder = $walletOrder;
        return $this;
    }
    /**
     * Get WalletLongName value
     * @return string|null
     */
    public function getWalletLongName()
    {
        return $this->WalletLongName;
    }
    /**
     * Set WalletLongName value
     * @param string $walletLongName
     * @return \StructType\WalletsEntity
     */
    public function setWalletLongName($walletLongName = null)
    {
        // validation for constraint: string
        if (!is_null($walletLongName) && !is_string($walletLongName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletLongName, true), gettype($walletLongName)), __LINE__);
        }
        $this->WalletLongName = $walletLongName;
        return $this;
    }
    /**
     * Get ServiceTypetName value
     * @return string|null
     */
    public function getServiceTypetName()
    {
        return $this->ServiceTypetName;
    }
    /**
     * Set ServiceTypetName value
     * @param string $serviceTypetName
     * @return \StructType\WalletsEntity
     */
    public function setServiceTypetName($serviceTypetName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceTypetName) && !is_string($serviceTypetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceTypetName, true), gettype($serviceTypetName)), __LINE__);
        }
        $this->ServiceTypetName = $serviceTypetName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\WalletsEntity
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get WalletType value
     * @return \StructType\WalletTypesEntity|null
     */
    public function getWalletType()
    {
        return $this->WalletType;
    }
    /**
     * Set WalletType value
     * @param \StructType\WalletTypesEntity $walletType
     * @return \StructType\WalletsEntity
     */
    public function setWalletType(\StructType\WalletTypesEntity $walletType = null)
    {
        $this->WalletType = $walletType;
        return $this;
    }
    /**
     * Get CurrencyType value
     * @return string|null
     */
    public function getCurrencyType()
    {
        return $this->CurrencyType;
    }
    /**
     * Set CurrencyType value
     * @param string $currencyType
     * @return \StructType\WalletsEntity
     */
    public function setCurrencyType($currencyType = null)
    {
        // validation for constraint: string
        if (!is_null($currencyType) && !is_string($currencyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyType, true), gettype($currencyType)), __LINE__);
        }
        $this->CurrencyType = $currencyType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WalletsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
