<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WalletEntityUI StructType
 * @subpackage Structs
 */
class WalletEntityUI extends AbstractStructBase
{
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The WalletName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletName;
    /**
     * The ListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ListName;
    /**
     * Constructor method for WalletEntityUI
     * @uses WalletEntityUI::setBalance()
     * @uses WalletEntityUI::setWalletName()
     * @uses WalletEntityUI::setListName()
     * @param float $balance
     * @param string $walletName
     * @param string $listName
     */
    public function __construct($balance = null, $walletName = null, $listName = null)
    {
        $this
            ->setBalance($balance)
            ->setWalletName($walletName)
            ->setListName($listName);
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\WalletEntityUI
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get WalletName value
     * @return string|null
     */
    public function getWalletName()
    {
        return $this->WalletName;
    }
    /**
     * Set WalletName value
     * @param string $walletName
     * @return \StructType\WalletEntityUI
     */
    public function setWalletName($walletName = null)
    {
        // validation for constraint: string
        if (!is_null($walletName) && !is_string($walletName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletName, true), gettype($walletName)), __LINE__);
        }
        $this->WalletName = $walletName;
        return $this;
    }
    /**
     * Get ListName value
     * @return string|null
     */
    public function getListName()
    {
        return $this->ListName;
    }
    /**
     * Set ListName value
     * @param string $listName
     * @return \StructType\WalletEntityUI
     */
    public function setListName($listName = null)
    {
        // validation for constraint: string
        if (!is_null($listName) && !is_string($listName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listName, true), gettype($listName)), __LINE__);
        }
        $this->ListName = $listName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WalletEntityUI
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
