<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateSmsActivation StructType
 * @subpackage Structs
 */
class ValidateSmsActivation extends AbstractStructBase
{
    /**
     * The accountTokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountTokenId;
    /**
     * The smsTokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $smsTokenId;
    /**
     * The smsCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $smsCode;
    /**
     * Constructor method for ValidateSmsActivation
     * @uses ValidateSmsActivation::setAccountTokenId()
     * @uses ValidateSmsActivation::setSmsTokenId()
     * @uses ValidateSmsActivation::setSmsCode()
     * @param string $accountTokenId
     * @param string $smsTokenId
     * @param string $smsCode
     */
    public function __construct($accountTokenId = null, $smsTokenId = null, $smsCode = null)
    {
        $this
            ->setAccountTokenId($accountTokenId)
            ->setSmsTokenId($smsTokenId)
            ->setSmsCode($smsCode);
    }
    /**
     * Get accountTokenId value
     * @return string|null
     */
    public function getAccountTokenId()
    {
        return $this->accountTokenId;
    }
    /**
     * Set accountTokenId value
     * @param string $accountTokenId
     * @return \StructType\ValidateSmsActivation
     */
    public function setAccountTokenId($accountTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($accountTokenId) && !is_string($accountTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountTokenId, true), gettype($accountTokenId)), __LINE__);
        }
        $this->accountTokenId = $accountTokenId;
        return $this;
    }
    /**
     * Get smsTokenId value
     * @return string|null
     */
    public function getSmsTokenId()
    {
        return $this->smsTokenId;
    }
    /**
     * Set smsTokenId value
     * @param string $smsTokenId
     * @return \StructType\ValidateSmsActivation
     */
    public function setSmsTokenId($smsTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($smsTokenId) && !is_string($smsTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smsTokenId, true), gettype($smsTokenId)), __LINE__);
        }
        $this->smsTokenId = $smsTokenId;
        return $this;
    }
    /**
     * Get smsCode value
     * @return string|null
     */
    public function getSmsCode()
    {
        return $this->smsCode;
    }
    /**
     * Set smsCode value
     * @param string $smsCode
     * @return \StructType\ValidateSmsActivation
     */
    public function setSmsCode($smsCode = null)
    {
        // validation for constraint: string
        if (!is_null($smsCode) && !is_string($smsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smsCode, true), gettype($smsCode)), __LINE__);
        }
        $this->smsCode = $smsCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateSmsActivation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
