<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionsEntity StructType
 * @subpackage Structs
 */
class TransactionsEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Currency;
    /**
     * The ServiceTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceTypeId;
    /**
     * The TransactionStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionStatus;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreateUserId;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The TransferDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransferDate;
    /**
     * The IsActived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActived;
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsArrived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsArrived;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAmount;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Commission;
    /**
     * The WalletFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletFrom;
    /**
     * The WalletTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletTo;
    /**
     * The IsTransactionCodeActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTransactionCodeActive;
    /**
     * The RequestStatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RequestStatusId;
    /**
     * The IsNameView
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNameView;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The IsAccounting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAccounting;
    /**
     * The IsEArchive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEArchive;
    /**
     * The MerchantCommisionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MerchantCommisionAmount;
    /**
     * The BuparaCommisionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BuparaCommisionAmount;
    /**
     * The WalletTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletTypeId;
    /**
     * The ToWalletTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToWalletTypeId;
    /**
     * The CreateDateString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateDateString;
    /**
     * The TransferDateString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransferDateString;
    /**
     * The CreateUserIp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateUserIp;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The WalletShortName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletShortName;
    /**
     * The FromWalletName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromWalletName;
    /**
     * The ToWalletName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToWalletName;
    /**
     * The TransactionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionCode;
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The AccountPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountPhone;
    /**
     * The ToAccountName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToAccountName;
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountCode;
    /**
     * The ServiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceTypesEntity
     */
    public $ServiceType;
    /**
     * The RequestStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RequestStatusEntity
     */
    public $RequestStatus;
    /**
     * The AccountIdentityNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountIdentityNo;
    /**
     * The CurrencyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyType;
    /**
     * The ToCurrencyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurrencyTypesEntity
     */
    public $ToCurrencyType;
    /**
     * The FromCurrencyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurrencyTypesEntity
     */
    public $FromCurrencyType;
    /**
     * The Ext
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ext;
    /**
     * The SendType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendType;
    /**
     * The SendTypeText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendTypeText;
    /**
     * The OperationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationType;
    /**
     * Constructor method for TransactionsEntity
     * @uses TransactionsEntity::setId()
     * @uses TransactionsEntity::setCurrency()
     * @uses TransactionsEntity::setServiceTypeId()
     * @uses TransactionsEntity::setTransactionStatus()
     * @uses TransactionsEntity::setCreateUserId()
     * @uses TransactionsEntity::setCreateDate()
     * @uses TransactionsEntity::setTransferDate()
     * @uses TransactionsEntity::setIsActived()
     * @uses TransactionsEntity::setIsDeleted()
     * @uses TransactionsEntity::setIsArrived()
     * @uses TransactionsEntity::setAmount()
     * @uses TransactionsEntity::setTotalAmount()
     * @uses TransactionsEntity::setCommission()
     * @uses TransactionsEntity::setWalletFrom()
     * @uses TransactionsEntity::setWalletTo()
     * @uses TransactionsEntity::setIsTransactionCodeActive()
     * @uses TransactionsEntity::setRequestStatusId()
     * @uses TransactionsEntity::setIsNameView()
     * @uses TransactionsEntity::setBalance()
     * @uses TransactionsEntity::setIsAccounting()
     * @uses TransactionsEntity::setIsEArchive()
     * @uses TransactionsEntity::setMerchantCommisionAmount()
     * @uses TransactionsEntity::setBuparaCommisionAmount()
     * @uses TransactionsEntity::setWalletTypeId()
     * @uses TransactionsEntity::setToWalletTypeId()
     * @uses TransactionsEntity::setCreateDateString()
     * @uses TransactionsEntity::setTransferDateString()
     * @uses TransactionsEntity::setCreateUserIp()
     * @uses TransactionsEntity::setTransactionId()
     * @uses TransactionsEntity::setDescription()
     * @uses TransactionsEntity::setWalletShortName()
     * @uses TransactionsEntity::setFromWalletName()
     * @uses TransactionsEntity::setToWalletName()
     * @uses TransactionsEntity::setTransactionCode()
     * @uses TransactionsEntity::setAccountName()
     * @uses TransactionsEntity::setAccountPhone()
     * @uses TransactionsEntity::setToAccountName()
     * @uses TransactionsEntity::setAccountCode()
     * @uses TransactionsEntity::setServiceType()
     * @uses TransactionsEntity::setRequestStatus()
     * @uses TransactionsEntity::setAccountIdentityNo()
     * @uses TransactionsEntity::setCurrencyType()
     * @uses TransactionsEntity::setToCurrencyType()
     * @uses TransactionsEntity::setFromCurrencyType()
     * @uses TransactionsEntity::setExt()
     * @uses TransactionsEntity::setSendType()
     * @uses TransactionsEntity::setSendTypeText()
     * @uses TransactionsEntity::setOperationType()
     * @param int $id
     * @param int $currency
     * @param int $serviceTypeId
     * @param int $transactionStatus
     * @param int $createUserId
     * @param string $createDate
     * @param string $transferDate
     * @param bool $isActived
     * @param bool $isDeleted
     * @param bool $isArrived
     * @param float $amount
     * @param float $totalAmount
     * @param float $commission
     * @param int $walletFrom
     * @param int $walletTo
     * @param bool $isTransactionCodeActive
     * @param int $requestStatusId
     * @param bool $isNameView
     * @param float $balance
     * @param bool $isAccounting
     * @param bool $isEArchive
     * @param float $merchantCommisionAmount
     * @param float $buparaCommisionAmount
     * @param int $walletTypeId
     * @param int $toWalletTypeId
     * @param string $createDateString
     * @param string $transferDateString
     * @param string $createUserIp
     * @param string $transactionId
     * @param string $description
     * @param string $walletShortName
     * @param string $fromWalletName
     * @param string $toWalletName
     * @param string $transactionCode
     * @param string $accountName
     * @param string $accountPhone
     * @param string $toAccountName
     * @param string $accountCode
     * @param \StructType\ServiceTypesEntity $serviceType
     * @param \StructType\RequestStatusEntity $requestStatus
     * @param string $accountIdentityNo
     * @param string $currencyType
     * @param \StructType\CurrencyTypesEntity $toCurrencyType
     * @param \StructType\CurrencyTypesEntity $fromCurrencyType
     * @param string $ext
     * @param string $sendType
     * @param string $sendTypeText
     * @param string $operationType
     */
    public function __construct($id = null, $currency = null, $serviceTypeId = null, $transactionStatus = null, $createUserId = null, $createDate = null, $transferDate = null, $isActived = null, $isDeleted = null, $isArrived = null, $amount = null, $totalAmount = null, $commission = null, $walletFrom = null, $walletTo = null, $isTransactionCodeActive = null, $requestStatusId = null, $isNameView = null, $balance = null, $isAccounting = null, $isEArchive = null, $merchantCommisionAmount = null, $buparaCommisionAmount = null, $walletTypeId = null, $toWalletTypeId = null, $createDateString = null, $transferDateString = null, $createUserIp = null, $transactionId = null, $description = null, $walletShortName = null, $fromWalletName = null, $toWalletName = null, $transactionCode = null, $accountName = null, $accountPhone = null, $toAccountName = null, $accountCode = null, \StructType\ServiceTypesEntity $serviceType = null, \StructType\RequestStatusEntity $requestStatus = null, $accountIdentityNo = null, $currencyType = null, \StructType\CurrencyTypesEntity $toCurrencyType = null, \StructType\CurrencyTypesEntity $fromCurrencyType = null, $ext = null, $sendType = null, $sendTypeText = null, $operationType = null)
    {
        $this
            ->setId($id)
            ->setCurrency($currency)
            ->setServiceTypeId($serviceTypeId)
            ->setTransactionStatus($transactionStatus)
            ->setCreateUserId($createUserId)
            ->setCreateDate($createDate)
            ->setTransferDate($transferDate)
            ->setIsActived($isActived)
            ->setIsDeleted($isDeleted)
            ->setIsArrived($isArrived)
            ->setAmount($amount)
            ->setTotalAmount($totalAmount)
            ->setCommission($commission)
            ->setWalletFrom($walletFrom)
            ->setWalletTo($walletTo)
            ->setIsTransactionCodeActive($isTransactionCodeActive)
            ->setRequestStatusId($requestStatusId)
            ->setIsNameView($isNameView)
            ->setBalance($balance)
            ->setIsAccounting($isAccounting)
            ->setIsEArchive($isEArchive)
            ->setMerchantCommisionAmount($merchantCommisionAmount)
            ->setBuparaCommisionAmount($buparaCommisionAmount)
            ->setWalletTypeId($walletTypeId)
            ->setToWalletTypeId($toWalletTypeId)
            ->setCreateDateString($createDateString)
            ->setTransferDateString($transferDateString)
            ->setCreateUserIp($createUserIp)
            ->setTransactionId($transactionId)
            ->setDescription($description)
            ->setWalletShortName($walletShortName)
            ->setFromWalletName($fromWalletName)
            ->setToWalletName($toWalletName)
            ->setTransactionCode($transactionCode)
            ->setAccountName($accountName)
            ->setAccountPhone($accountPhone)
            ->setToAccountName($toAccountName)
            ->setAccountCode($accountCode)
            ->setServiceType($serviceType)
            ->setRequestStatus($requestStatus)
            ->setAccountIdentityNo($accountIdentityNo)
            ->setCurrencyType($currencyType)
            ->setToCurrencyType($toCurrencyType)
            ->setFromCurrencyType($fromCurrencyType)
            ->setExt($ext)
            ->setSendType($sendType)
            ->setSendTypeText($sendTypeText)
            ->setOperationType($operationType);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\TransactionsEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Currency value
     * @return int
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param int $currency
     * @return \StructType\TransactionsEntity
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: int
        if (!is_null($currency) && !(is_int($currency) || ctype_digit($currency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get ServiceTypeId value
     * @return int
     */
    public function getServiceTypeId()
    {
        return $this->ServiceTypeId;
    }
    /**
     * Set ServiceTypeId value
     * @param int $serviceTypeId
     * @return \StructType\TransactionsEntity
     */
    public function setServiceTypeId($serviceTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceTypeId) && !(is_int($serviceTypeId) || ctype_digit($serviceTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceTypeId, true), gettype($serviceTypeId)), __LINE__);
        }
        $this->ServiceTypeId = $serviceTypeId;
        return $this;
    }
    /**
     * Get TransactionStatus value
     * @return int
     */
    public function getTransactionStatus()
    {
        return $this->TransactionStatus;
    }
    /**
     * Set TransactionStatus value
     * @param int $transactionStatus
     * @return \StructType\TransactionsEntity
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: int
        if (!is_null($transactionStatus) && !(is_int($transactionStatus) || ctype_digit($transactionStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionStatus, true), gettype($transactionStatus)), __LINE__);
        }
        $this->TransactionStatus = $transactionStatus;
        return $this;
    }
    /**
     * Get CreateUserId value
     * @return int
     */
    public function getCreateUserId()
    {
        return $this->CreateUserId;
    }
    /**
     * Set CreateUserId value
     * @param int $createUserId
     * @return \StructType\TransactionsEntity
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: int
        if (!is_null($createUserId) && !(is_int($createUserId) || ctype_digit($createUserId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        $this->CreateUserId = $createUserId;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\TransactionsEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get TransferDate value
     * @return string
     */
    public function getTransferDate()
    {
        return $this->TransferDate;
    }
    /**
     * Set TransferDate value
     * @param string $transferDate
     * @return \StructType\TransactionsEntity
     */
    public function setTransferDate($transferDate = null)
    {
        // validation for constraint: string
        if (!is_null($transferDate) && !is_string($transferDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferDate, true), gettype($transferDate)), __LINE__);
        }
        $this->TransferDate = $transferDate;
        return $this;
    }
    /**
     * Get IsActived value
     * @return bool
     */
    public function getIsActived()
    {
        return $this->IsActived;
    }
    /**
     * Set IsActived value
     * @param bool $isActived
     * @return \StructType\TransactionsEntity
     */
    public function setIsActived($isActived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActived) && !is_bool($isActived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActived, true), gettype($isActived)), __LINE__);
        }
        $this->IsActived = $isActived;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\TransactionsEntity
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get IsArrived value
     * @return bool
     */
    public function getIsArrived()
    {
        return $this->IsArrived;
    }
    /**
     * Set IsArrived value
     * @param bool $isArrived
     * @return \StructType\TransactionsEntity
     */
    public function setIsArrived($isArrived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isArrived) && !is_bool($isArrived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isArrived, true), gettype($isArrived)), __LINE__);
        }
        $this->IsArrived = $isArrived;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\TransactionsEntity
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \StructType\TransactionsEntity
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get Commission value
     * @return float
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param float $commission
     * @return \StructType\TransactionsEntity
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get WalletFrom value
     * @return int
     */
    public function getWalletFrom()
    {
        return $this->WalletFrom;
    }
    /**
     * Set WalletFrom value
     * @param int $walletFrom
     * @return \StructType\TransactionsEntity
     */
    public function setWalletFrom($walletFrom = null)
    {
        // validation for constraint: int
        if (!is_null($walletFrom) && !(is_int($walletFrom) || ctype_digit($walletFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletFrom, true), gettype($walletFrom)), __LINE__);
        }
        $this->WalletFrom = $walletFrom;
        return $this;
    }
    /**
     * Get WalletTo value
     * @return int
     */
    public function getWalletTo()
    {
        return $this->WalletTo;
    }
    /**
     * Set WalletTo value
     * @param int $walletTo
     * @return \StructType\TransactionsEntity
     */
    public function setWalletTo($walletTo = null)
    {
        // validation for constraint: int
        if (!is_null($walletTo) && !(is_int($walletTo) || ctype_digit($walletTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletTo, true), gettype($walletTo)), __LINE__);
        }
        $this->WalletTo = $walletTo;
        return $this;
    }
    /**
     * Get IsTransactionCodeActive value
     * @return bool
     */
    public function getIsTransactionCodeActive()
    {
        return $this->IsTransactionCodeActive;
    }
    /**
     * Set IsTransactionCodeActive value
     * @param bool $isTransactionCodeActive
     * @return \StructType\TransactionsEntity
     */
    public function setIsTransactionCodeActive($isTransactionCodeActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransactionCodeActive) && !is_bool($isTransactionCodeActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTransactionCodeActive, true), gettype($isTransactionCodeActive)), __LINE__);
        }
        $this->IsTransactionCodeActive = $isTransactionCodeActive;
        return $this;
    }
    /**
     * Get RequestStatusId value
     * @return int
     */
    public function getRequestStatusId()
    {
        return $this->RequestStatusId;
    }
    /**
     * Set RequestStatusId value
     * @param int $requestStatusId
     * @return \StructType\TransactionsEntity
     */
    public function setRequestStatusId($requestStatusId = null)
    {
        // validation for constraint: int
        if (!is_null($requestStatusId) && !(is_int($requestStatusId) || ctype_digit($requestStatusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestStatusId, true), gettype($requestStatusId)), __LINE__);
        }
        $this->RequestStatusId = $requestStatusId;
        return $this;
    }
    /**
     * Get IsNameView value
     * @return bool
     */
    public function getIsNameView()
    {
        return $this->IsNameView;
    }
    /**
     * Set IsNameView value
     * @param bool $isNameView
     * @return \StructType\TransactionsEntity
     */
    public function setIsNameView($isNameView = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNameView) && !is_bool($isNameView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNameView, true), gettype($isNameView)), __LINE__);
        }
        $this->IsNameView = $isNameView;
        return $this;
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\TransactionsEntity
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get IsAccounting value
     * @return bool
     */
    public function getIsAccounting()
    {
        return $this->IsAccounting;
    }
    /**
     * Set IsAccounting value
     * @param bool $isAccounting
     * @return \StructType\TransactionsEntity
     */
    public function setIsAccounting($isAccounting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccounting) && !is_bool($isAccounting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccounting, true), gettype($isAccounting)), __LINE__);
        }
        $this->IsAccounting = $isAccounting;
        return $this;
    }
    /**
     * Get IsEArchive value
     * @return bool
     */
    public function getIsEArchive()
    {
        return $this->IsEArchive;
    }
    /**
     * Set IsEArchive value
     * @param bool $isEArchive
     * @return \StructType\TransactionsEntity
     */
    public function setIsEArchive($isEArchive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEArchive) && !is_bool($isEArchive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEArchive, true), gettype($isEArchive)), __LINE__);
        }
        $this->IsEArchive = $isEArchive;
        return $this;
    }
    /**
     * Get MerchantCommisionAmount value
     * @return float
     */
    public function getMerchantCommisionAmount()
    {
        return $this->MerchantCommisionAmount;
    }
    /**
     * Set MerchantCommisionAmount value
     * @param float $merchantCommisionAmount
     * @return \StructType\TransactionsEntity
     */
    public function setMerchantCommisionAmount($merchantCommisionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($merchantCommisionAmount) && !(is_float($merchantCommisionAmount) || is_numeric($merchantCommisionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($merchantCommisionAmount, true), gettype($merchantCommisionAmount)), __LINE__);
        }
        $this->MerchantCommisionAmount = $merchantCommisionAmount;
        return $this;
    }
    /**
     * Get BuparaCommisionAmount value
     * @return float
     */
    public function getBuparaCommisionAmount()
    {
        return $this->BuparaCommisionAmount;
    }
    /**
     * Set BuparaCommisionAmount value
     * @param float $buparaCommisionAmount
     * @return \StructType\TransactionsEntity
     */
    public function setBuparaCommisionAmount($buparaCommisionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($buparaCommisionAmount) && !(is_float($buparaCommisionAmount) || is_numeric($buparaCommisionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($buparaCommisionAmount, true), gettype($buparaCommisionAmount)), __LINE__);
        }
        $this->BuparaCommisionAmount = $buparaCommisionAmount;
        return $this;
    }
    /**
     * Get WalletTypeId value
     * @return int
     */
    public function getWalletTypeId()
    {
        return $this->WalletTypeId;
    }
    /**
     * Set WalletTypeId value
     * @param int $walletTypeId
     * @return \StructType\TransactionsEntity
     */
    public function setWalletTypeId($walletTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($walletTypeId) && !(is_int($walletTypeId) || ctype_digit($walletTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletTypeId, true), gettype($walletTypeId)), __LINE__);
        }
        $this->WalletTypeId = $walletTypeId;
        return $this;
    }
    /**
     * Get ToWalletTypeId value
     * @return int
     */
    public function getToWalletTypeId()
    {
        return $this->ToWalletTypeId;
    }
    /**
     * Set ToWalletTypeId value
     * @param int $toWalletTypeId
     * @return \StructType\TransactionsEntity
     */
    public function setToWalletTypeId($toWalletTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($toWalletTypeId) && !(is_int($toWalletTypeId) || ctype_digit($toWalletTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toWalletTypeId, true), gettype($toWalletTypeId)), __LINE__);
        }
        $this->ToWalletTypeId = $toWalletTypeId;
        return $this;
    }
    /**
     * Get CreateDateString value
     * @return string|null
     */
    public function getCreateDateString()
    {
        return $this->CreateDateString;
    }
    /**
     * Set CreateDateString value
     * @param string $createDateString
     * @return \StructType\TransactionsEntity
     */
    public function setCreateDateString($createDateString = null)
    {
        // validation for constraint: string
        if (!is_null($createDateString) && !is_string($createDateString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateString, true), gettype($createDateString)), __LINE__);
        }
        $this->CreateDateString = $createDateString;
        return $this;
    }
    /**
     * Get TransferDateString value
     * @return string|null
     */
    public function getTransferDateString()
    {
        return $this->TransferDateString;
    }
    /**
     * Set TransferDateString value
     * @param string $transferDateString
     * @return \StructType\TransactionsEntity
     */
    public function setTransferDateString($transferDateString = null)
    {
        // validation for constraint: string
        if (!is_null($transferDateString) && !is_string($transferDateString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferDateString, true), gettype($transferDateString)), __LINE__);
        }
        $this->TransferDateString = $transferDateString;
        return $this;
    }
    /**
     * Get CreateUserIp value
     * @return string|null
     */
    public function getCreateUserIp()
    {
        return $this->CreateUserIp;
    }
    /**
     * Set CreateUserIp value
     * @param string $createUserIp
     * @return \StructType\TransactionsEntity
     */
    public function setCreateUserIp($createUserIp = null)
    {
        // validation for constraint: string
        if (!is_null($createUserIp) && !is_string($createUserIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createUserIp, true), gettype($createUserIp)), __LINE__);
        }
        $this->CreateUserIp = $createUserIp;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \StructType\TransactionsEntity
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\TransactionsEntity
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get WalletShortName value
     * @return string|null
     */
    public function getWalletShortName()
    {
        return $this->WalletShortName;
    }
    /**
     * Set WalletShortName value
     * @param string $walletShortName
     * @return \StructType\TransactionsEntity
     */
    public function setWalletShortName($walletShortName = null)
    {
        // validation for constraint: string
        if (!is_null($walletShortName) && !is_string($walletShortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletShortName, true), gettype($walletShortName)), __LINE__);
        }
        $this->WalletShortName = $walletShortName;
        return $this;
    }
    /**
     * Get FromWalletName value
     * @return string|null
     */
    public function getFromWalletName()
    {
        return $this->FromWalletName;
    }
    /**
     * Set FromWalletName value
     * @param string $fromWalletName
     * @return \StructType\TransactionsEntity
     */
    public function setFromWalletName($fromWalletName = null)
    {
        // validation for constraint: string
        if (!is_null($fromWalletName) && !is_string($fromWalletName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromWalletName, true), gettype($fromWalletName)), __LINE__);
        }
        $this->FromWalletName = $fromWalletName;
        return $this;
    }
    /**
     * Get ToWalletName value
     * @return string|null
     */
    public function getToWalletName()
    {
        return $this->ToWalletName;
    }
    /**
     * Set ToWalletName value
     * @param string $toWalletName
     * @return \StructType\TransactionsEntity
     */
    public function setToWalletName($toWalletName = null)
    {
        // validation for constraint: string
        if (!is_null($toWalletName) && !is_string($toWalletName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toWalletName, true), gettype($toWalletName)), __LINE__);
        }
        $this->ToWalletName = $toWalletName;
        return $this;
    }
    /**
     * Get TransactionCode value
     * @return string|null
     */
    public function getTransactionCode()
    {
        return $this->TransactionCode;
    }
    /**
     * Set TransactionCode value
     * @param string $transactionCode
     * @return \StructType\TransactionsEntity
     */
    public function setTransactionCode($transactionCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionCode) && !is_string($transactionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionCode, true), gettype($transactionCode)), __LINE__);
        }
        $this->TransactionCode = $transactionCode;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\TransactionsEntity
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get AccountPhone value
     * @return string|null
     */
    public function getAccountPhone()
    {
        return $this->AccountPhone;
    }
    /**
     * Set AccountPhone value
     * @param string $accountPhone
     * @return \StructType\TransactionsEntity
     */
    public function setAccountPhone($accountPhone = null)
    {
        // validation for constraint: string
        if (!is_null($accountPhone) && !is_string($accountPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountPhone, true), gettype($accountPhone)), __LINE__);
        }
        $this->AccountPhone = $accountPhone;
        return $this;
    }
    /**
     * Get ToAccountName value
     * @return string|null
     */
    public function getToAccountName()
    {
        return $this->ToAccountName;
    }
    /**
     * Set ToAccountName value
     * @param string $toAccountName
     * @return \StructType\TransactionsEntity
     */
    public function setToAccountName($toAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($toAccountName) && !is_string($toAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toAccountName, true), gettype($toAccountName)), __LINE__);
        }
        $this->ToAccountName = $toAccountName;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \StructType\TransactionsEntity
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return \StructType\ServiceTypesEntity|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param \StructType\ServiceTypesEntity $serviceType
     * @return \StructType\TransactionsEntity
     */
    public function setServiceType(\StructType\ServiceTypesEntity $serviceType = null)
    {
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get RequestStatus value
     * @return \StructType\RequestStatusEntity|null
     */
    public function getRequestStatus()
    {
        return $this->RequestStatus;
    }
    /**
     * Set RequestStatus value
     * @param \StructType\RequestStatusEntity $requestStatus
     * @return \StructType\TransactionsEntity
     */
    public function setRequestStatus(\StructType\RequestStatusEntity $requestStatus = null)
    {
        $this->RequestStatus = $requestStatus;
        return $this;
    }
    /**
     * Get AccountIdentityNo value
     * @return string|null
     */
    public function getAccountIdentityNo()
    {
        return $this->AccountIdentityNo;
    }
    /**
     * Set AccountIdentityNo value
     * @param string $accountIdentityNo
     * @return \StructType\TransactionsEntity
     */
    public function setAccountIdentityNo($accountIdentityNo = null)
    {
        // validation for constraint: string
        if (!is_null($accountIdentityNo) && !is_string($accountIdentityNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountIdentityNo, true), gettype($accountIdentityNo)), __LINE__);
        }
        $this->AccountIdentityNo = $accountIdentityNo;
        return $this;
    }
    /**
     * Get CurrencyType value
     * @return string|null
     */
    public function getCurrencyType()
    {
        return $this->CurrencyType;
    }
    /**
     * Set CurrencyType value
     * @param string $currencyType
     * @return \StructType\TransactionsEntity
     */
    public function setCurrencyType($currencyType = null)
    {
        // validation for constraint: string
        if (!is_null($currencyType) && !is_string($currencyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyType, true), gettype($currencyType)), __LINE__);
        }
        $this->CurrencyType = $currencyType;
        return $this;
    }
    /**
     * Get ToCurrencyType value
     * @return \StructType\CurrencyTypesEntity|null
     */
    public function getToCurrencyType()
    {
        return $this->ToCurrencyType;
    }
    /**
     * Set ToCurrencyType value
     * @param \StructType\CurrencyTypesEntity $toCurrencyType
     * @return \StructType\TransactionsEntity
     */
    public function setToCurrencyType(\StructType\CurrencyTypesEntity $toCurrencyType = null)
    {
        $this->ToCurrencyType = $toCurrencyType;
        return $this;
    }
    /**
     * Get FromCurrencyType value
     * @return \StructType\CurrencyTypesEntity|null
     */
    public function getFromCurrencyType()
    {
        return $this->FromCurrencyType;
    }
    /**
     * Set FromCurrencyType value
     * @param \StructType\CurrencyTypesEntity $fromCurrencyType
     * @return \StructType\TransactionsEntity
     */
    public function setFromCurrencyType(\StructType\CurrencyTypesEntity $fromCurrencyType = null)
    {
        $this->FromCurrencyType = $fromCurrencyType;
        return $this;
    }
    /**
     * Get Ext value
     * @return string|null
     */
    public function getExt()
    {
        return $this->Ext;
    }
    /**
     * Set Ext value
     * @param string $ext
     * @return \StructType\TransactionsEntity
     */
    public function setExt($ext = null)
    {
        // validation for constraint: string
        if (!is_null($ext) && !is_string($ext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ext, true), gettype($ext)), __LINE__);
        }
        $this->Ext = $ext;
        return $this;
    }
    /**
     * Get SendType value
     * @return string|null
     */
    public function getSendType()
    {
        return $this->SendType;
    }
    /**
     * Set SendType value
     * @param string $sendType
     * @return \StructType\TransactionsEntity
     */
    public function setSendType($sendType = null)
    {
        // validation for constraint: string
        if (!is_null($sendType) && !is_string($sendType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendType, true), gettype($sendType)), __LINE__);
        }
        $this->SendType = $sendType;
        return $this;
    }
    /**
     * Get SendTypeText value
     * @return string|null
     */
    public function getSendTypeText()
    {
        return $this->SendTypeText;
    }
    /**
     * Set SendTypeText value
     * @param string $sendTypeText
     * @return \StructType\TransactionsEntity
     */
    public function setSendTypeText($sendTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($sendTypeText) && !is_string($sendTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendTypeText, true), gettype($sendTypeText)), __LINE__);
        }
        $this->SendTypeText = $sendTypeText;
        return $this;
    }
    /**
     * Get OperationType value
     * @return string|null
     */
    public function getOperationType()
    {
        return $this->OperationType;
    }
    /**
     * Set OperationType value
     * @param string $operationType
     * @return \StructType\TransactionsEntity
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: string
        if (!is_null($operationType) && !is_string($operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationType, true), gettype($operationType)), __LINE__);
        }
        $this->OperationType = $operationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionsEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
