<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingGetAdressList StructType
 * @subpackage Structs
 */
class ShoppingGetAdressList extends AbstractStructBase
{
    /**
     * The adressType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $adressType;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * Constructor method for ShoppingGetAdressList
     * @uses ShoppingGetAdressList::setAdressType()
     * @uses ShoppingGetAdressList::setTokenId()
     * @param int $adressType
     * @param string $tokenId
     */
    public function __construct($adressType = null, $tokenId = null)
    {
        $this
            ->setAdressType($adressType)
            ->setTokenId($tokenId);
    }
    /**
     * Get adressType value
     * @return int
     */
    public function getAdressType()
    {
        return $this->adressType;
    }
    /**
     * Set adressType value
     * @param int $adressType
     * @return \StructType\ShoppingGetAdressList
     */
    public function setAdressType($adressType = null)
    {
        // validation for constraint: int
        if (!is_null($adressType) && !(is_int($adressType) || ctype_digit($adressType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adressType, true), gettype($adressType)), __LINE__);
        }
        $this->adressType = $adressType;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\ShoppingGetAdressList
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingGetAdressList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
