<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingAddtoCart StructType
 * @subpackage Structs
 */
class ShoppingAddtoCart extends AbstractStructBase
{
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The jsonData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $jsonData;
    /**
     * Constructor method for ShoppingAddtoCart
     * @uses ShoppingAddtoCart::setTokenId()
     * @uses ShoppingAddtoCart::setJsonData()
     * @param string $tokenId
     * @param string $jsonData
     */
    public function __construct($tokenId = null, $jsonData = null)
    {
        $this
            ->setTokenId($tokenId)
            ->setJsonData($jsonData);
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\ShoppingAddtoCart
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get jsonData value
     * @return string|null
     */
    public function getJsonData()
    {
        return $this->jsonData;
    }
    /**
     * Set jsonData value
     * @param string $jsonData
     * @return \StructType\ShoppingAddtoCart
     */
    public function setJsonData($jsonData = null)
    {
        // validation for constraint: string
        if (!is_null($jsonData) && !is_string($jsonData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jsonData, true), gettype($jsonData)), __LINE__);
        }
        $this->jsonData = $jsonData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingAddtoCart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
