<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingAdditionEntity StructType
 * @subpackage Structs
 */
class ShoppingAdditionEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The ClosedTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ClosedTime;
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsActived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActived;
    /**
     * The CreateDateString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateDateString;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The TableId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TableId;
    /**
     * The CompanyImageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyImageUrl;
    /**
     * The ShoppingAdditionDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfShoppingAdditionDetailEntity
     */
    public $ShoppingAdditionDetail;
    /**
     * Constructor method for ShoppingAdditionEntity
     * @uses ShoppingAdditionEntity::setId()
     * @uses ShoppingAdditionEntity::setAccountId()
     * @uses ShoppingAdditionEntity::setStatus()
     * @uses ShoppingAdditionEntity::setAmount()
     * @uses ShoppingAdditionEntity::setCreateDate()
     * @uses ShoppingAdditionEntity::setClosedTime()
     * @uses ShoppingAdditionEntity::setIsDeleted()
     * @uses ShoppingAdditionEntity::setIsActived()
     * @uses ShoppingAdditionEntity::setCreateDateString()
     * @uses ShoppingAdditionEntity::setOrderId()
     * @uses ShoppingAdditionEntity::setTableId()
     * @uses ShoppingAdditionEntity::setCompanyImageUrl()
     * @uses ShoppingAdditionEntity::setShoppingAdditionDetail()
     * @param int $id
     * @param int $accountId
     * @param int $status
     * @param float $amount
     * @param string $createDate
     * @param string $closedTime
     * @param bool $isDeleted
     * @param bool $isActived
     * @param string $createDateString
     * @param string $orderId
     * @param string $tableId
     * @param string $companyImageUrl
     * @param \ArrayType\ArrayOfShoppingAdditionDetailEntity $shoppingAdditionDetail
     */
    public function __construct($id = null, $accountId = null, $status = null, $amount = null, $createDate = null, $closedTime = null, $isDeleted = null, $isActived = null, $createDateString = null, $orderId = null, $tableId = null, $companyImageUrl = null, \ArrayType\ArrayOfShoppingAdditionDetailEntity $shoppingAdditionDetail = null)
    {
        $this
            ->setId($id)
            ->setAccountId($accountId)
            ->setStatus($status)
            ->setAmount($amount)
            ->setCreateDate($createDate)
            ->setClosedTime($closedTime)
            ->setIsDeleted($isDeleted)
            ->setIsActived($isActived)
            ->setCreateDateString($createDateString)
            ->setOrderId($orderId)
            ->setTableId($tableId)
            ->setCompanyImageUrl($companyImageUrl)
            ->setShoppingAdditionDetail($shoppingAdditionDetail);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get AccountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get ClosedTime value
     * @return string
     */
    public function getClosedTime()
    {
        return $this->ClosedTime;
    }
    /**
     * Set ClosedTime value
     * @param string $closedTime
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setClosedTime($closedTime = null)
    {
        // validation for constraint: string
        if (!is_null($closedTime) && !is_string($closedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closedTime, true), gettype($closedTime)), __LINE__);
        }
        $this->ClosedTime = $closedTime;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get IsActived value
     * @return bool
     */
    public function getIsActived()
    {
        return $this->IsActived;
    }
    /**
     * Set IsActived value
     * @param bool $isActived
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setIsActived($isActived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActived) && !is_bool($isActived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActived, true), gettype($isActived)), __LINE__);
        }
        $this->IsActived = $isActived;
        return $this;
    }
    /**
     * Get CreateDateString value
     * @return string|null
     */
    public function getCreateDateString()
    {
        return $this->CreateDateString;
    }
    /**
     * Set CreateDateString value
     * @param string $createDateString
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setCreateDateString($createDateString = null)
    {
        // validation for constraint: string
        if (!is_null($createDateString) && !is_string($createDateString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateString, true), gettype($createDateString)), __LINE__);
        }
        $this->CreateDateString = $createDateString;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get TableId value
     * @return string|null
     */
    public function getTableId()
    {
        return $this->TableId;
    }
    /**
     * Set TableId value
     * @param string $tableId
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setTableId($tableId = null)
    {
        // validation for constraint: string
        if (!is_null($tableId) && !is_string($tableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tableId, true), gettype($tableId)), __LINE__);
        }
        $this->TableId = $tableId;
        return $this;
    }
    /**
     * Get CompanyImageUrl value
     * @return string|null
     */
    public function getCompanyImageUrl()
    {
        return $this->CompanyImageUrl;
    }
    /**
     * Set CompanyImageUrl value
     * @param string $companyImageUrl
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setCompanyImageUrl($companyImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($companyImageUrl) && !is_string($companyImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyImageUrl, true), gettype($companyImageUrl)), __LINE__);
        }
        $this->CompanyImageUrl = $companyImageUrl;
        return $this;
    }
    /**
     * Get ShoppingAdditionDetail value
     * @return \ArrayType\ArrayOfShoppingAdditionDetailEntity|null
     */
    public function getShoppingAdditionDetail()
    {
        return $this->ShoppingAdditionDetail;
    }
    /**
     * Set ShoppingAdditionDetail value
     * @param \ArrayType\ArrayOfShoppingAdditionDetailEntity $shoppingAdditionDetail
     * @return \StructType\ShoppingAdditionEntity
     */
    public function setShoppingAdditionDetail(\ArrayType\ArrayOfShoppingAdditionDetailEntity $shoppingAdditionDetail = null)
    {
        $this->ShoppingAdditionDetail = $shoppingAdditionDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingAdditionEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
