<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingAdditionDetailEntity StructType
 * @subpackage Structs
 */
class ShoppingAdditionDetailEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The AdditionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdditionId;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The IsPay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPay;
    /**
     * The PayType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PayType;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryName;
    /**
     * Constructor method for ShoppingAdditionDetailEntity
     * @uses ShoppingAdditionDetailEntity::setId()
     * @uses ShoppingAdditionDetailEntity::setAdditionId()
     * @uses ShoppingAdditionDetailEntity::setAmount()
     * @uses ShoppingAdditionDetailEntity::setIsPay()
     * @uses ShoppingAdditionDetailEntity::setPayType()
     * @uses ShoppingAdditionDetailEntity::setProductName()
     * @uses ShoppingAdditionDetailEntity::setCategoryName()
     * @param int $id
     * @param int $additionId
     * @param float $amount
     * @param bool $isPay
     * @param int $payType
     * @param string $productName
     * @param string $categoryName
     */
    public function __construct($id = null, $additionId = null, $amount = null, $isPay = null, $payType = null, $productName = null, $categoryName = null)
    {
        $this
            ->setId($id)
            ->setAdditionId($additionId)
            ->setAmount($amount)
            ->setIsPay($isPay)
            ->setPayType($payType)
            ->setProductName($productName)
            ->setCategoryName($categoryName);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ShoppingAdditionDetailEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get AdditionId value
     * @return int
     */
    public function getAdditionId()
    {
        return $this->AdditionId;
    }
    /**
     * Set AdditionId value
     * @param int $additionId
     * @return \StructType\ShoppingAdditionDetailEntity
     */
    public function setAdditionId($additionId = null)
    {
        // validation for constraint: int
        if (!is_null($additionId) && !(is_int($additionId) || ctype_digit($additionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($additionId, true), gettype($additionId)), __LINE__);
        }
        $this->AdditionId = $additionId;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ShoppingAdditionDetailEntity
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get IsPay value
     * @return bool
     */
    public function getIsPay()
    {
        return $this->IsPay;
    }
    /**
     * Set IsPay value
     * @param bool $isPay
     * @return \StructType\ShoppingAdditionDetailEntity
     */
    public function setIsPay($isPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPay) && !is_bool($isPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPay, true), gettype($isPay)), __LINE__);
        }
        $this->IsPay = $isPay;
        return $this;
    }
    /**
     * Get PayType value
     * @return int
     */
    public function getPayType()
    {
        return $this->PayType;
    }
    /**
     * Set PayType value
     * @param int $payType
     * @return \StructType\ShoppingAdditionDetailEntity
     */
    public function setPayType($payType = null)
    {
        // validation for constraint: int
        if (!is_null($payType) && !(is_int($payType) || ctype_digit($payType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payType, true), gettype($payType)), __LINE__);
        }
        $this->PayType = $payType;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\ShoppingAdditionDetailEntity
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \StructType\ShoppingAdditionDetailEntity
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryName, true), gettype($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingAdditionDetailEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
