<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShareWalletCodforMail StructType
 * @subpackage Structs
 */
class ShareWalletCodforMail extends AbstractStructBase
{
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The walletCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $walletCode;
    /**
     * Constructor method for ShareWalletCodforMail
     * @uses ShareWalletCodforMail::setTokenId()
     * @uses ShareWalletCodforMail::setWalletCode()
     * @param string $tokenId
     * @param string $walletCode
     */
    public function __construct($tokenId = null, $walletCode = null)
    {
        $this
            ->setTokenId($tokenId)
            ->setWalletCode($walletCode);
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\ShareWalletCodforMail
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get walletCode value
     * @return string|null
     */
    public function getWalletCode()
    {
        return $this->walletCode;
    }
    /**
     * Set walletCode value
     * @param string $walletCode
     * @return \StructType\ShareWalletCodforMail
     */
    public function setWalletCode($walletCode = null)
    {
        // validation for constraint: string
        if (!is_null($walletCode) && !is_string($walletCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletCode, true), gettype($walletCode)), __LINE__);
        }
        $this->walletCode = $walletCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShareWalletCodforMail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
