<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetWalletOrder StructType
 * @subpackage Structs
 */
class SetWalletOrder extends AbstractStructBase
{
    /**
     * The walletId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $walletId;
    /**
     * The newWalletId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $newWalletId;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * Constructor method for SetWalletOrder
     * @uses SetWalletOrder::setWalletId()
     * @uses SetWalletOrder::setNewWalletId()
     * @uses SetWalletOrder::setType()
     * @uses SetWalletOrder::setTokenId()
     * @param int $walletId
     * @param int $newWalletId
     * @param string $type
     * @param string $tokenId
     */
    public function __construct($walletId = null, $newWalletId = null, $type = null, $tokenId = null)
    {
        $this
            ->setWalletId($walletId)
            ->setNewWalletId($newWalletId)
            ->setType($type)
            ->setTokenId($tokenId);
    }
    /**
     * Get walletId value
     * @return int
     */
    public function getWalletId()
    {
        return $this->walletId;
    }
    /**
     * Set walletId value
     * @param int $walletId
     * @return \StructType\SetWalletOrder
     */
    public function setWalletId($walletId = null)
    {
        // validation for constraint: int
        if (!is_null($walletId) && !(is_int($walletId) || ctype_digit($walletId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletId, true), gettype($walletId)), __LINE__);
        }
        $this->walletId = $walletId;
        return $this;
    }
    /**
     * Get newWalletId value
     * @return int
     */
    public function getNewWalletId()
    {
        return $this->newWalletId;
    }
    /**
     * Set newWalletId value
     * @param int $newWalletId
     * @return \StructType\SetWalletOrder
     */
    public function setNewWalletId($newWalletId = null)
    {
        // validation for constraint: int
        if (!is_null($newWalletId) && !(is_int($newWalletId) || ctype_digit($newWalletId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newWalletId, true), gettype($newWalletId)), __LINE__);
        }
        $this->newWalletId = $newWalletId;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\MoveType::valueIsValid()
     * @uses \EnumType\MoveType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\SetWalletOrder
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MoveType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MoveType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\MoveType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\SetWalletOrder
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetWalletOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
