<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendMessageAnswer StructType
 * @subpackage Structs
 */
class SendMessageAnswer extends AbstractStructBase
{
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The messageBody
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messageBody;
    /**
     * The messageCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messageCode;
    /**
     * Constructor method for SendMessageAnswer
     * @uses SendMessageAnswer::setTokenId()
     * @uses SendMessageAnswer::setMessageBody()
     * @uses SendMessageAnswer::setMessageCode()
     * @param string $tokenId
     * @param string $messageBody
     * @param string $messageCode
     */
    public function __construct($tokenId = null, $messageBody = null, $messageCode = null)
    {
        $this
            ->setTokenId($tokenId)
            ->setMessageBody($messageBody)
            ->setMessageCode($messageCode);
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\SendMessageAnswer
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get messageBody value
     * @return string|null
     */
    public function getMessageBody()
    {
        return $this->messageBody;
    }
    /**
     * Set messageBody value
     * @param string $messageBody
     * @return \StructType\SendMessageAnswer
     */
    public function setMessageBody($messageBody = null)
    {
        // validation for constraint: string
        if (!is_null($messageBody) && !is_string($messageBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageBody, true), gettype($messageBody)), __LINE__);
        }
        $this->messageBody = $messageBody;
        return $this;
    }
    /**
     * Get messageCode value
     * @return string|null
     */
    public function getMessageCode()
    {
        return $this->messageCode;
    }
    /**
     * Set messageCode value
     * @param string $messageCode
     * @return \StructType\SendMessageAnswer
     */
    public function setMessageCode($messageCode = null)
    {
        // validation for constraint: string
        if (!is_null($messageCode) && !is_string($messageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageCode, true), gettype($messageCode)), __LINE__);
        }
        $this->messageCode = $messageCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendMessageAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
