<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendMessage StructType
 * @subpackage Structs
 */
class SendMessage extends AbstractStructBase
{
    /**
     * The sendtype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $sendtype;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The toAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $toAccount;
    /**
     * The messageSubject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messageSubject;
    /**
     * The messageBody
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messageBody;
    /**
     * Constructor method for SendMessage
     * @uses SendMessage::setSendtype()
     * @uses SendMessage::setTokenId()
     * @uses SendMessage::setToAccount()
     * @uses SendMessage::setMessageSubject()
     * @uses SendMessage::setMessageBody()
     * @param int $sendtype
     * @param string $tokenId
     * @param string $toAccount
     * @param string $messageSubject
     * @param string $messageBody
     */
    public function __construct($sendtype = null, $tokenId = null, $toAccount = null, $messageSubject = null, $messageBody = null)
    {
        $this
            ->setSendtype($sendtype)
            ->setTokenId($tokenId)
            ->setToAccount($toAccount)
            ->setMessageSubject($messageSubject)
            ->setMessageBody($messageBody);
    }
    /**
     * Get sendtype value
     * @return int
     */
    public function getSendtype()
    {
        return $this->sendtype;
    }
    /**
     * Set sendtype value
     * @param int $sendtype
     * @return \StructType\SendMessage
     */
    public function setSendtype($sendtype = null)
    {
        // validation for constraint: int
        if (!is_null($sendtype) && !(is_int($sendtype) || ctype_digit($sendtype))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sendtype, true), gettype($sendtype)), __LINE__);
        }
        $this->sendtype = $sendtype;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\SendMessage
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get toAccount value
     * @return string|null
     */
    public function getToAccount()
    {
        return $this->toAccount;
    }
    /**
     * Set toAccount value
     * @param string $toAccount
     * @return \StructType\SendMessage
     */
    public function setToAccount($toAccount = null)
    {
        // validation for constraint: string
        if (!is_null($toAccount) && !is_string($toAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toAccount, true), gettype($toAccount)), __LINE__);
        }
        $this->toAccount = $toAccount;
        return $this;
    }
    /**
     * Get messageSubject value
     * @return string|null
     */
    public function getMessageSubject()
    {
        return $this->messageSubject;
    }
    /**
     * Set messageSubject value
     * @param string $messageSubject
     * @return \StructType\SendMessage
     */
    public function setMessageSubject($messageSubject = null)
    {
        // validation for constraint: string
        if (!is_null($messageSubject) && !is_string($messageSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageSubject, true), gettype($messageSubject)), __LINE__);
        }
        $this->messageSubject = $messageSubject;
        return $this;
    }
    /**
     * Get messageBody value
     * @return string|null
     */
    public function getMessageBody()
    {
        return $this->messageBody;
    }
    /**
     * Set messageBody value
     * @param string $messageBody
     * @return \StructType\SendMessage
     */
    public function setMessageBody($messageBody = null)
    {
        // validation for constraint: string
        if (!is_null($messageBody) && !is_string($messageBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageBody, true), gettype($messageBody)), __LINE__);
        }
        $this->messageBody = $messageBody;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
